/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.wetness.WetnessInfo;
import homeostatic.network.IData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class WetnessData
implements IData {
    int wetnessLevel;
    float moistureLevel;

    public WetnessData(WetnessInfo wetnessInfo) {
        this.wetnessLevel = wetnessInfo.getWetnessLevel();
        this.moistureLevel = wetnessInfo.getMoistureLevel();
    }

    public WetnessData(FriendlyByteBuf buf) {
        this.wetnessLevel = buf.readInt();
        this.moistureLevel = buf.readFloat();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.wetnessLevel);
        buf.writeFloat(this.moistureLevel);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> Minecraft.m_91087_().f_91074_.getCapability(CapabilityRegistry.WETNESS_CAPABILITY).ifPresent(data -> {
                data.setWetnessLevel(this.wetnessLevel);
                data.setMoistureLevel(this.moistureLevel);
            }));
        }
    }
}

