/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.config.ConfigHandler;
import homeostatic.util.Alignment;
import homeostatic.util.ColorHelper;
import homeostatic.util.FontHelper;
import homeostatic.util.TempHelper;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;

public class TemperatureInfo {
    public void renderText(PoseStack matrix, Minecraft mc, BlockPos pos, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.f_91074_;
        player.getCapability(CapabilityRegistry.TEMPERATURE_CAPABILITY).ifPresent(data -> {
            TempHelper.TemperatureDirection skinTemperatureDirection = TempHelper.getSkinTemperatureDirection(data.getLocalTemperature(), data.getSkinTemperature());
            TempHelper.TemperatureDirection coreTemperatureDirection = TempHelper.getCoreTemperatureDirection(data.getLastSkinTemperature(), data.getCoreTemperature(), data.getSkinTemperature());
            String skinIcon = TemperatureInfo.getDirectionIcon(skinTemperatureDirection);
            String coreIcon = TemperatureInfo.getDirectionIcon(coreTemperatureDirection);
            String localTemp = String.format(" %.2f", TempHelper.convertMcTemp(data.getLocalTemperature(), ConfigHandler.Client.useFahrenheit()));
            String skinTemp = String.format("s: %.2f%s", TempHelper.convertMcTemp(data.getSkinTemperature(), ConfigHandler.Client.useFahrenheit()), skinIcon);
            String coreTemp = String.format(" c: %.2f%s ", TempHelper.convertMcTemp(data.getCoreTemperature(), ConfigHandler.Client.useFahrenheit()), coreIcon);
            int localTempWidth = mc.f_91062_.m_92895_(localTemp);
            int skinTempWidth = mc.f_91062_.m_92895_(skinTemp) + localTempWidth;
            int coreTempWidth = mc.f_91062_.m_92895_(coreTemp) + skinTempWidth;
            Objects.requireNonNull(mc.f_91062_);
            int y = Alignment.getY(scaledHeight, 1, 9);
            FontHelper.draw(mc, matrix, localTemp, Alignment.getX(scaledWidth, localTempWidth), y, ColorHelper.getLocalTemperatureColor(data.getLocalTemperature()));
            FontHelper.draw(mc, matrix, skinTemp, Alignment.getX(scaledWidth, skinTempWidth), y, ColorHelper.getTemperatureColor(data.getSkinTemperature()));
            FontHelper.draw(mc, matrix, coreTemp, Alignment.getX(scaledWidth, coreTempWidth), y, ColorHelper.getTemperatureColor(data.getCoreTemperature()));
        });
    }

    public static String getDirectionIcon(TempHelper.TemperatureDirection direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case TempHelper.TemperatureDirection.COOLING -> "\u2193";
            case TempHelper.TemperatureDirection.COOLING_RAPIDLY -> "\u21ca";
            case TempHelper.TemperatureDirection.WARMING -> "\u2191";
            case TempHelper.TemperatureDirection.WARMING_RAPIDLY -> "\u21c8";
            case TempHelper.TemperatureDirection.NONE -> "\u00b7";
            case TempHelper.TemperatureDirection.COOLING_NORMALLY -> "\u02ec";
            case TempHelper.TemperatureDirection.WARMING_NORMALLY -> "\u02c6";
        };
    }
}

