/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.config.ConfigHandler;
import homeostatic.overlay.TemperatureInfo;
import homeostatic.util.ColorHelper;
import homeostatic.util.OverlayHelper;
import homeostatic.util.TempHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;

public class TemperatureOverlay
extends GuiComponent {
    public static final ResourceLocation BURNING_OVERLAY = new ResourceLocation("homeostatic", "textures/gui/burning.png");
    public static final ResourceLocation HYPERTHERMIA_OVERLAY = new ResourceLocation("homeostatic", "textures/gui/hyperthermia.png");
    public static final ResourceLocation ICONS = new ResourceLocation("homeostatic", "textures/gui/icons.png");
    protected static final int ICON_WIDTH = 13;
    protected static final int ICON_HEIGHT = 26;

    public void render(PoseStack matrix, Minecraft mc, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.f_91074_;
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS);
        player.getCapability(CapabilityRegistry.TEMPERATURE_CAPABILITY).ifPresent(data -> {
            int offsetX = scaledWidth / 2 + 95;
            int pY = scaledHeight - 27;
            float textScale = 0.5f;
            int textOffsetX = (int)((float)scaledWidth / textScale) / 2 + 189;
            int textOffsetY = (int)((float)scaledHeight / textScale) - 15;
            int pV = 0;
            boolean pU = false;
            int pUOffset = 53;
            int lineOffset = this.getTempLineOffset(data.getCoreTemperature());
            TempHelper.TemperatureDirection coreTemperatureDirection = TempHelper.getCoreTemperatureDirection(data.getLastSkinTemperature(), data.getCoreTemperature(), data.getSkinTemperature());
            String coreIcon = TemperatureInfo.getDirectionIcon(coreTemperatureDirection);
            String coreTempSmall = String.format("%.1f\u00b0%s", TempHelper.convertMcTemp(data.getCoreTemperature(), ConfigHandler.Client.useFahrenheit()), coreIcon);
            String localTemp = String.format("%.0f\u00b0", TempHelper.convertMcTemp(data.getLocalTemperature(), ConfigHandler.Client.useFahrenheit()));
            if (data.getSkinTemperature() > 2.5572288f) {
                float alpha = 0.33f + (data.getSkinTemperature() - 2.5572288f);
                OverlayHelper.renderTexture(BURNING_OVERLAY, scaledWidth, scaledHeight, alpha);
            }
            if (data.getCoreTemperature() > 1.7993976f) {
                OverlayHelper.renderTexture(HYPERTHERMIA_OVERLAY, scaledWidth, scaledHeight, 0.4f);
            }
            if (data.getCoreTemperature() > 1.7659639f) {
                this.m_93228_(matrix, offsetX, pY, pUOffset, pV + 26, 13, 26);
            } else if (data.getCoreTemperature() < 1.5898795f) {
                this.m_93228_(matrix, offsetX, pY, pUOffset, pV + 52, 13, 26);
            } else {
                this.m_93228_(matrix, offsetX, pY, pUOffset, pV, 13, 26);
            }
            this.m_93228_(matrix, offsetX, pY, pUOffset + 13, pV + lineOffset, 13, 26);
            matrix.m_85841_(textScale, textScale, textScale);
            mc.f_91062_.m_92750_(matrix, localTemp, (float)(textOffsetX + 23 - mc.f_91062_.m_92895_(localTemp)), (float)(textOffsetY - 50), ColorHelper.getLocalTemperatureColor(data.getLocalTemperature()));
            mc.f_91062_.m_92750_(matrix, coreTempSmall, (float)textOffsetX, (float)textOffsetY, ColorHelper.getTemperatureColor(data.getCoreTemperature()));
        });
    }

    private int getTempLineOffset(float coreTemp) {
        int offset = coreTemp <= 1.6344578f ? (coreTemp <= 1.5542169f ? 1 : Math.round((coreTemp - 1.5542169f) / 0.011462f)) : (coreTemp >= 1.7993976f ? 15 : 15 - Math.round((1.7993976f - coreTemp) / 0.020617f));
        return offset;
    }
}

