/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import homeostatic.config.ConfigHandler;
import java.awt.Color;

public class ColorHelper {
    private static final Color neutral = ColorHelper.decode("#f9ffff");

    public static int getTemperatureColor(float temperature) {
        Color hot = ConfigHandler.Client.temperatureColorHot();
        Color cold = ConfigHandler.Client.temperatureColorCold();
        if (temperature > 1.6344578f) {
            int step = temperature > 1.7993976f ? 16 : (int)Math.floor((temperature - 1.6344578f) / 0.0103f);
            return ColorHelper.getRangeColor(neutral, hot, 16, step);
        }
        int step = temperature < 1.5542169f ? 16 : (int)Math.floor((1.6344578f - temperature) / 0.005f);
        return ColorHelper.getRangeColor(neutral, cold, 16, step);
    }

    public static int getLocalTemperatureColor(float temperature) {
        Color hot = ConfigHandler.Client.temperatureColorHot();
        Color cold = ConfigHandler.Client.temperatureColorCold();
        if (temperature > 1.108f) {
            int step = temperature > 2.557f ? 16 : (int)Math.floor((temperature - 1.108f) / 0.0905f);
            return ColorHelper.getRangeColor(neutral, hot, 16, step);
        }
        int step = temperature < -0.34036145f ? 16 : (int)Math.floor((1.108f - temperature) / 4.0f);
        return ColorHelper.getRangeColor(neutral, cold, 16, step);
    }

    public static Color decode(String color) {
        return Color.decode(color);
    }

    private static int getRangeColor(Color from, Color to, int steps, int step) {
        int diffRed = to.getRed() - from.getRed();
        int diffGreen = to.getGreen() - from.getGreen();
        int diffBlue = to.getBlue() - from.getBlue();
        return new Color(from.getRed() + diffRed * step / steps, from.getGreen() + diffGreen * step / steps, from.getBlue() + diffBlue * step / steps).getRGB();
    }
}

