/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

public class TempHelper {
    public static TemperatureDirection getCoreTemperatureDirection(float lastSkinTemperature, float coreTemperature, float skinTemperature) {
        TemperatureDirection direction = TemperatureDirection.NONE;
        if (lastSkinTemperature > skinTemperature) {
            direction = TemperatureDirection.COOLING_NORMALLY;
            if (coreTemperature > 1.6344578f) {
                direction = skinTemperature < coreTemperature ? TemperatureDirection.COOLING_RAPIDLY : TemperatureDirection.COOLING;
            }
        } else if (lastSkinTemperature < skinTemperature) {
            direction = TemperatureDirection.WARMING_NORMALLY;
            if (coreTemperature < 1.6344578f) {
                direction = skinTemperature > coreTemperature ? TemperatureDirection.WARMING_RAPIDLY : TemperatureDirection.WARMING;
            }
        }
        return direction;
    }

    public static TemperatureDirection getSkinTemperatureDirection(float localTemperature, float lastSkinTemperature) {
        TemperatureDirection direction = TemperatureDirection.NONE;
        if (lastSkinTemperature > 1.6344578f) {
            if (localTemperature > 1.22f) {
                direction = TemperatureDirection.WARMING_NORMALLY;
                if (localTemperature > 1.888f) {
                    direction = TemperatureDirection.WARMING;
                }
            } else if (localTemperature < 1.22f) {
                direction = TemperatureDirection.COOLING;
                if (localTemperature < 0.997f) {
                    direction = TemperatureDirection.COOLING_RAPIDLY;
                }
            }
        } else if (lastSkinTemperature < 1.6344578f) {
            if (localTemperature > 0.997f) {
                direction = TemperatureDirection.WARMING_NORMALLY;
                if (localTemperature > 2.557f) {
                    direction = TemperatureDirection.WARMING_RAPIDLY;
                } else if (localTemperature > 1.22f) {
                    direction = TemperatureDirection.WARMING;
                }
            } else {
                direction = TemperatureDirection.COOLING_NORMALLY;
            }
        } else if (localTemperature > 1.22f) {
            direction = TemperatureDirection.WARMING_NORMALLY;
        } else if (localTemperature < 0.997f) {
            direction = TemperatureDirection.COOLING_NORMALLY;
        }
        return direction;
    }

    public static double convertMcTemp(float mcTemp, boolean fahrenheit) {
        double temp = 25.27027027 + 44.86486486 * (double)mcTemp;
        if (!fahrenheit) {
            temp = (temp - 32.0) * 0.5556;
        }
        return temp;
    }

    public static double convertTemp(double temp, boolean fahrenheit) {
        double toConvert = temp;
        if (!fahrenheit) {
            toConvert = temp / 0.5556 + 32.0;
        }
        return (toConvert - 25.27027027) / 44.86486486;
    }

    public static double getHeatIndex(float dryTemp, double rh) {
        double hIndex;
        double dryTempF = TempHelper.convertMcTemp(dryTemp, true);
        if (dryTempF < 80.0) {
            hIndex = 0.5 * (dryTempF + 61.0 + (dryTempF - 68.0) * 1.2) + rh * 0.094;
        } else {
            hIndex = -42.379 + 2.04901523 * dryTempF + 10.14333127 * rh;
            hIndex = hIndex - 0.22475541 * dryTempF * rh - 6.83783 * Math.pow(10.0, -3.0) * dryTempF * dryTempF;
            hIndex -= 5.481717 * Math.pow(10.0, -2.0) * rh * rh;
            hIndex += 1.22874 * Math.pow(10.0, -3.0) * dryTempF * dryTempF * rh;
            hIndex += 8.5282 * Math.pow(10.0, -4.0) * dryTempF * rh * rh;
            hIndex -= 1.99 * Math.pow(10.0, -6.0) * dryTempF * dryTempF * rh * rh;
        }
        return TempHelper.convertTemp(hIndex, true);
    }

    public static double getBlackGlobe(double radiation, float dryTemp, double relativeHumidity) {
        double dryTempC = TempHelper.convertMcTemp(dryTemp, false);
        double blackGlobeTemp = 0.01498 * radiation + 1.184 * dryTempC - 0.0789 * (relativeHumidity / 100.0) - 2.739;
        return TempHelper.convertTemp(blackGlobeTemp, false);
    }

    public static enum TemperatureDirection {
        WARMING(0.025f),
        WARMING_NORMALLY(0.00625f),
        WARMING_RAPIDLY(0.2f),
        NONE(0.0f),
        COOLING(0.0125f),
        COOLING_NORMALLY(0.00625f),
        COOLING_RAPIDLY(0.2f);

        public final float coreRate;

        private TemperatureDirection(float coreRate) {
            this.coreRate = coreRate;
        }
    }
}

