/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.biome;

import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;

public class BiomeData {
    public static final float FROZEN_OFFSET = -0.31f;
    public static final float SNOW_OFFSET = -0.446f;
    public static final float MC_DEGREE = 0.022289157f;
    private final float temperature;
    private double humidity;
    private final float seasonVariation;
    private final float dayNightOffset;

    BiomeData(float temperature, double humidity, double seasonVariation, double dayNightOffset) {
        this.humidity = humidity;
        this.seasonVariation = (float)seasonVariation * 0.022289157f;
        this.dayNightOffset = (float)dayNightOffset * 0.022289157f;
        this.temperature = temperature;
    }

    public float getTemperature(Biome.TemperatureModifier temperatureModifier, Biome.Precipitation precipitation) {
        float temperature = this.temperature;
        if (temperatureModifier == Biome.TemperatureModifier.FROZEN) {
            temperature += -0.31f;
        } else if (precipitation == Biome.Precipitation.SNOW) {
            temperature += -0.446f;
        }
        return temperature;
    }

    public Biome.Precipitation getPrecipitation(Float temperature, Biome.Precipitation precipitation) {
        if (temperature.floatValue() == -0.25f && precipitation == Biome.Precipitation.RAIN) {
            return Biome.Precipitation.SNOW;
        }
        return precipitation;
    }

    public float getRawTemperature() {
        return this.temperature;
    }

    public double getHumidity(Holder<Biome> biome) {
        if (((Biome)biome.m_203334_()).m_47554_() < 0.33f) {
            this.humidity = 20.0;
        }
        return this.humidity;
    }

    public double getRawHumidity(Biome biome) {
        return this.humidity;
    }

    public float getSeasonVariation(Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.SNOW) {
            return this.seasonVariation / 2.0f;
        }
        return this.seasonVariation;
    }

    public float getDayNightOffset(Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.SNOW) {
            return this.dayNightOffset / 2.0f;
        }
        return this.dayNightOffset;
    }

    public String toString() {
        return "BiomeData{temperature=" + this.temperature + ", humidity=" + this.humidity + ", seasonVariation=" + this.seasonVariation + ", dayNightOffset=" + this.dayNightOffset + "}";
    }
}

