/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.biome;

import biomesoplenty.api.biome.BOPBiomes;
import homeostatic.Homeostatic;
import homeostatic.common.biome.BiomeData;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.NetherPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.fml.ModList;
import potionstudios.byg.common.world.biome.BYGBiomes;

public class BiomeRegistry {
    public static final Map<BiomeCategory, BiomeData> BIOMES = new HashMap<BiomeCategory, BiomeData>();
    private static final Map<ResourceKey<Biome>, BiomeCategory> BIOME_CATEGORY = new HashMap<ResourceKey<Biome>, BiomeCategory>();
    private static final BiomeData BOG = new BiomeData(0.351f, 60.0, 40.0, 10.0);
    private static final BiomeData COLD_OCEAN = new BiomeData(0.373f, 20.0, 20.0, 5.0);
    private static final BiomeData COLD_FOREST = new BiomeData(0.373f, 60.0, 40.0, 12.0);
    private static final BiomeData COLD_DESERT = new BiomeData(0.395f, 20.0, 40.0, 20.0);
    private static final BiomeData DEEP_COLD_OCEAN = new BiomeData(0.44f, 20.0, 20.0, 5.0);
    private static final BiomeData ICY = new BiomeData(0.507f, 20.0, 20.0, 5.0);
    private static final BiomeData TAIGA = new BiomeData(0.507f, 50.0, 40.0, 10.0);
    private static final BiomeData OCEAN = new BiomeData(0.551f, 70.0, 40.0, 10.0);
    private static final BiomeData RIVER = new BiomeData(0.551f, 70.0, 40.0, 10.0);
    private static final BiomeData DEEP_LUKEWARM_OCEAN = new BiomeData(0.596f, 70.0, 40.0, 10.0);
    private static final BiomeData EXTREME_HILLS = new BiomeData(0.618f, 50.0, 40.0, 10.0);
    private static final BiomeData MOUNTAIN = new BiomeData(0.618f, 50.0, 40.0, 10.0);
    private static final BiomeData LUKEWARM_OCEAN = new BiomeData(0.64f, 70.0, 40.0, 10.0);
    private static final BiomeData BEACH = new BiomeData(0.663f, 70.0, 40.0, 10.0);
    private static final BiomeData FOREST = new BiomeData(0.663f, 50.0, 40.0, 12.0);
    public static final BiomeData UNDERGROUND = new BiomeData(0.663f, 40.0, 40.0, 12.0);
    private static final BiomeData SWAMP = new BiomeData(0.685f, 90.0, 40.0, 12.0);
    private static final BiomeData MUSHROOM = new BiomeData(0.685f, 70.0, 40.0, 12.0);
    private static final BiomeData WARM_OCEAN = new BiomeData(0.73f, 70.0, 40.0, 10.0);
    private static final BiomeData PLAINS = new BiomeData(0.774f, 60.0, 40.0, 15.0);
    private static final BiomeData LUSH_DESERT = new BiomeData(0.886f, 60.0, 40.0, 15.0);
    private static final BiomeData DRYLAND = new BiomeData(0.886f, 35.0, 40.0, 15.0);
    private static final BiomeData RAINFOREST = new BiomeData(0.886f, 95.0, 40.0, 15.0);
    private static final BiomeData JUNGLE = new BiomeData(0.997f, 90.0, 40.0, 15.0);
    private static final BiomeData VOLCANIC = new BiomeData(1.04f, 35.0, 40.0, 15.0);
    private static final BiomeData SAVANNA = new BiomeData(1.108f, 30.0, 40.0, 15.0);
    private static final BiomeData MESA = new BiomeData(1.309f, 20.0, 40.0, 15.0);
    private static final BiomeData DESERT = new BiomeData(1.354f, 20.0, 40.0, 20.0);
    private static final BiomeData NONE = new BiomeData(0.15f, 40.0, 40.0, 0.0);
    private static final BiomeData THEEND = new BiomeData(0.551f, 40.0, 40.0, 0.0);
    private static final BiomeData NETHER = new BiomeData(1.666f, 20.0, 40.0, 0.0);

    public static BiomeData getDataForBiome(Holder<Biome> biome) {
        BiomeCategory biomeCategory = BiomeRegistry.getBiomeCategory(biome);
        if (biomeCategory == BiomeCategory.MISSING) {
            return new BiomeData(((Biome)biome.get()).m_47554_(), 40.0, 40.0, 10.0);
        }
        return BIOMES.get((Object)biomeCategory);
    }

    public static void init() {
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48173_, BiomeCategory.NONE);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48202_, BiomeCategory.PLAINS);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48176_, BiomeCategory.PLAINS);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186761_, BiomeCategory.ICY);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48182_, BiomeCategory.ICY);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48203_, BiomeCategory.DESERT);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48207_, BiomeCategory.SWAMP);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_220595_, BiomeCategory.SWAMP);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186755_, BiomeCategory.FOREST);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48149_, BiomeCategory.FOREST);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186762_, BiomeCategory.FOREST);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48151_, BiomeCategory.FOREST);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48205_, BiomeCategory.FOREST);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48179_, BiomeCategory.FOREST);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186763_, BiomeCategory.TAIGA);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48206_, BiomeCategory.TAIGA);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48152_, BiomeCategory.TAIGA);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186764_, BiomeCategory.TAIGA);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48157_, BiomeCategory.SAVANNA);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48158_, BiomeCategory.SAVANNA);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186768_, BiomeCategory.SAVANNA);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186765_, BiomeCategory.EXTREME_HILLS);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186766_, BiomeCategory.EXTREME_HILLS);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186767_, BiomeCategory.EXTREME_HILLS);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186760_, BiomeCategory.EXTREME_HILLS);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48222_, BiomeCategory.JUNGLE);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186769_, BiomeCategory.JUNGLE);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48197_, BiomeCategory.JUNGLE);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48159_, BiomeCategory.MESA);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48194_, BiomeCategory.MESA);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186753_, BiomeCategory.MESA);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186756_, BiomeCategory.MOUNTAIN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186758_, BiomeCategory.MOUNTAIN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186757_, BiomeCategory.MOUNTAIN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186754_, BiomeCategory.MOUNTAIN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_186759_, BiomeCategory.MOUNTAIN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48208_, BiomeCategory.RIVER);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48212_, BiomeCategory.RIVER);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48217_, BiomeCategory.BEACH);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48148_, BiomeCategory.BEACH);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48166_, BiomeCategory.WARM_OCEAN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48167_, BiomeCategory.LUKEWARM_OCEAN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48170_, BiomeCategory.DEEP_LUKEWARM_OCEAN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48172_, BiomeCategory.DEEP_COLD_OCEAN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48211_, BiomeCategory.COLD_OCEAN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48174_, BiomeCategory.OCEAN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48225_, BiomeCategory.OCEAN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48168_, BiomeCategory.COLD_OCEAN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48171_, BiomeCategory.DEEP_COLD_OCEAN);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48215_, BiomeCategory.MUSHROOM);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_151784_, BiomeCategory.UNDERGROUND);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_220594_, BiomeCategory.UNDERGROUND);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_151785_, BiomeCategory.UNDERGROUND);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48209_, BiomeCategory.NETHER);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48201_, BiomeCategory.NETHER);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48200_, BiomeCategory.NETHER);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48199_, BiomeCategory.NETHER);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48175_, BiomeCategory.NETHER);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48210_, BiomeCategory.THEEND);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48164_, BiomeCategory.THEEND);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48163_, BiomeCategory.THEEND);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48162_, BiomeCategory.THEEND);
        BIOME_CATEGORY.put((ResourceKey<Biome>)Biomes.f_48165_, BiomeCategory.THEEND);
        if (ModList.get().isLoaded("biomesoplenty")) {
            BOPBiomes.getAllBiomes().forEach(biomeResourceKey -> {
                switch (biomeResourceKey.m_135782_().m_135815_()) {
                    case "seasonal_forest": 
                    case "seasonal_orchard": 
                    case "pumpkin_patch": 
                    case "boreal_forest": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.COLD_FOREST);
                        break;
                    }
                    case "marsh": 
                    case "bayou": 
                    case "fungal_jungle": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.SWAMP);
                        break;
                    }
                    case "rainbow_hills": 
                    case "snowy_coniferous_forest": 
                    case "snowy_fir_clearing": 
                    case "snowy_maple_woods": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.MOUNTAIN);
                        break;
                    }
                    case "floodplain": 
                    case "rocky_rainforest": 
                    case "rainforest": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.RAINFOREST);
                        break;
                    }
                    case "wetland": 
                    case "grassland": 
                    case "clover_patch": 
                    case "muskeg": 
                    case "shrubland": 
                    case "rocky_shrubland": 
                    case "cherry_blossom_grove": 
                    case "bamboo_grove": 
                    case "field": 
                    case "forested_field": 
                    case "lavender_field": 
                    case "lavender_forest": 
                    case "orchard": 
                    case "pasture": 
                    case "prairie": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.PLAINS);
                        break;
                    }
                    case "fir_clearing": 
                    case "coniferous_forest": 
                    case "ominous_woods": 
                    case "origin_valley": 
                    case "highland_moor": 
                    case "highland": 
                    case "crag": 
                    case "jade_cliffs": 
                    case "maple_woods": 
                    case "mystic_grove": 
                    case "old_growth_woodland": 
                    case "redwood_forest": 
                    case "woodland": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.FOREST);
                        break;
                    }
                    case "dryland": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.DRYLAND);
                        break;
                    }
                    case "cold_desert": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.COLD_DESERT);
                        break;
                    }
                    case "dune_beach": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.BEACH);
                        break;
                    }
                    case "scrubland": 
                    case "wooded_scrubland": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.SAVANNA);
                        break;
                    }
                    case "bog": 
                    case "tundra": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.BOG);
                        break;
                    }
                    case "crystalline_chasm": 
                    case "erupting_inferno": 
                    case "undergrowth": 
                    case "visceral_heap": 
                    case "withered_abyss": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.NETHER);
                        break;
                    }
                    case "dead_forest": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.EXTREME_HILLS);
                        break;
                    }
                    case "glowing_grotto": 
                    case "spider_nest": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.RIVER);
                        break;
                    }
                    case "volcano": 
                    case "volcanic_plains": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.VOLCANIC);
                        break;
                    }
                    case "old_growth_dead_forest": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.TAIGA);
                        break;
                    }
                    case "tropics": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.JUNGLE);
                        break;
                    }
                    case "lush_desert": 
                    case "lush_savanna": 
                    case "mediterranean_forest": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.LUSH_DESERT);
                        break;
                    }
                    case "wasteland": 
                    case "wooded_wasteland": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.MESA);
                        break;
                    }
                    default: {
                        Homeostatic.LOGGER.debug("Missing default category for BOP Biome: %s", (Object)biomeResourceKey.m_135782_());
                    }
                }
            });
        }
        if (ModList.get().isLoaded("byg")) {
            BYGBiomes.BIOMES_BY_TAG.forEach((biomeTagKey, biomeRegistryObject) -> {
                ResourceKey biomeResourceKey = biomeRegistryObject.getResourceKey();
                switch (biomeResourceKey.m_135782_().m_135815_()) {
                    case "allium_fields": 
                    case "amaranth_fields": 
                    case "autumnal_valley": 
                    case "coconino_meadow": 
                    case "cardinal_tundra": 
                    case "prairie": 
                    case "rose_fields": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.PLAINS);
                        break;
                    }
                    case "araucaria_savanna": 
                    case "baobab_savanna": 
                    case "firecracker_shrubland": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.SAVANNA);
                        break;
                    }
                    case "aspen_forest": 
                    case "borealis_grove": 
                    case "cherry_blossom_forest": 
                    case "cika_woods": 
                    case "ebony_woods": 
                    case "forgotten_forest": 
                    case "grove": 
                    case "orchard": 
                    case "autumnal_forest": 
                    case "temperate_rainforest": 
                    case "zelkova_forest": 
                    case "redwood_thicket": 
                    case "red_oak_forest": 
                    case "fragment_forest": 
                    case "temperate_grove": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.FOREST);
                        break;
                    }
                    case "atacama_desert": 
                    case "windswept_desert": 
                    case "mojave_desert": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.DESERT);
                        break;
                    }
                    case "bayou": 
                    case "white_mangrove_marshes": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.SWAMP);
                        break;
                    }
                    case "black_forest": 
                    case "canadian_shield": 
                    case "coniferous_forest": 
                    case "dacite_ridges": 
                    case "maple_taiga": 
                    case "autumnal_taiga": 
                    case "frosted_taiga": 
                    case "frosted_coniferous_forest": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.TAIGA);
                        break;
                    }
                    case "crag_gardens": 
                    case "guiana_shield": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.JUNGLE);
                        break;
                    }
                    case "cypress_swamplands": 
                    case "skyris_vale": 
                    case "dacite_shore": 
                    case "twilight_meadow": 
                    case "weeping_witch_forest": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.BOG);
                        break;
                    }
                    case "lush_stacks": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.WARM_OCEAN);
                        break;
                    }
                    case "dead_sea": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.VOLCANIC);
                        break;
                    }
                    case "howling_peaks": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.MOUNTAIN);
                        break;
                    }
                    case "jacaranda_forest": 
                    case "tropical_rainforest": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.RAINFOREST);
                        break;
                    }
                    case "red_rock_valley": 
                    case "sierra_badlands": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.MESA);
                        break;
                    }
                    case "shattered_glacier": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.ICY);
                        break;
                    }
                    case "rainbow_beach": 
                    case "basalt_barrera": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.BEACH);
                        break;
                    }
                    case "brimstone_caverns": 
                    case "crimson_gardens": 
                    case "embur_bog": 
                    case "glowstone_gardens": 
                    case "magma_wastes": 
                    case "subzero_hypogeal": 
                    case "sythian_torrids": 
                    case "warped_desert": 
                    case "wailing_garth": 
                    case "arisian_undergrowth": 
                    case "weeping_mire": 
                    case "quartz_desert": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.NETHER);
                        break;
                    }
                    case "ivis_fields": 
                    case "nightshade_forest": 
                    case "ethereal_islands": 
                    case "viscal_isles": 
                    case "bulbis_gardens": 
                    case "shulkren_forest": 
                    case "cryptic_wastes": 
                    case "imparius_grove": {
                        BIOME_CATEGORY.put((ResourceKey<Biome>)biomeResourceKey, BiomeCategory.THEEND);
                        break;
                    }
                    default: {
                        Homeostatic.LOGGER.debug("Missing default category for BYG Biome: %s", (Object)biomeResourceKey.m_135782_());
                    }
                }
            });
        }
    }

    public static BiomeCategory getBiomeCategory(Holder<Biome> biome) {
        try {
            Optional key = biome.m_203543_();
            if (key.isPresent()) {
                return BIOME_CATEGORY.getOrDefault(key.get(), BiomeCategory.MISSING);
            }
        }
        catch (NoSuchElementException e) {
            Homeostatic.LOGGER.debug("Unable to find biome for: %s", (Object)biome.toString());
        }
        return BiomeCategory.MISSING;
    }

    public static BiomeCategory getBiomeCategory(BiomeGenerationSettings generationSettings, float temperature, MobSpawnSettings mobSpawnSettings, Biome.TemperatureModifier temperatureModifier, float downfall, Biome.Precipitation precipitation, BiomeSpecialEffects specialEffects) {
        BiomeCategory biomeCategory = BiomeCategory.MISSING;
        if (temperature == -0.2f) {
            biomeCategory = BiomeCategory.FOREST;
        } else if (temperature == -0.25f) {
            biomeCategory = downfall == 0.6f && precipitation == Biome.Precipitation.SNOW ? BiomeCategory.PLAINS : BiomeCategory.MOUNTAIN;
        } else if (temperature == -0.3f) {
            biomeCategory = BiomeCategory.MOUNTAIN;
        } else if (temperature == -0.5f) {
            biomeCategory = downfall == 0.9f ? BiomeCategory.ICY : BiomeCategory.TAIGA;
        } else if (temperature == -0.7f) {
            biomeCategory = BiomeCategory.MOUNTAIN;
        } else if (temperature == 0.05f) {
            biomeCategory = BiomeCategory.BEACH;
        } else if (temperature == 0.0f) {
            biomeCategory = generationSettings.m_186658_((PlacedFeature)MiscOverworldPlacements.f_195260_.get()) || generationSettings.m_186658_((PlacedFeature)VegetationPlacements.f_195431_.get()) ? BiomeCategory.ICY : (temperatureModifier == Biome.TemperatureModifier.FROZEN ? BiomeCategory.COLD_OCEAN : BiomeCategory.RIVER);
        } else if (temperature == 0.145f) {
            biomeCategory = BiomeCategory.PLAINS;
        } else if (temperature == 0.15f) {
            if (downfall == 0.5f) {
                biomeCategory = BiomeCategory.MOUNTAIN;
            }
        } else if (temperature == 0.2f) {
            biomeCategory = downfall == 0.5f ? BiomeCategory.BOG : BiomeCategory.EXTREME_HILLS;
        } else if (temperature == 0.25f) {
            if (generationSettings.m_186658_((PlacedFeature)VegetationPlacements.f_195456_.get()) || generationSettings.m_186658_((PlacedFeature)VegetationPlacements.f_195457_.get())) {
                biomeCategory = BiomeCategory.TAIGA;
            } else if (generationSettings.m_186658_((PlacedFeature)VegetationPlacements.f_195442_.get())) {
                biomeCategory = BiomeCategory.TAIGA;
            } else if (mobSpawnSettings.getEntityTypes().contains(EntityType.f_20508_)) {
                biomeCategory = BiomeCategory.FOREST;
            } else if (specialEffects.m_47984_().isPresent() && (Integer)specialEffects.m_47984_().get() == 9470285) {
                biomeCategory = BiomeCategory.FOREST;
            } else if (downfall == 0.5f || downfall == 0.9f) {
                biomeCategory = BiomeCategory.FOREST;
            } else if (downfall == 0.0f) {
                biomeCategory = BiomeCategory.COLD_DESERT;
            } else if (downfall == 0.8f) {
                biomeCategory = BiomeCategory.BOG;
            }
        } else if (temperature == 0.3f) {
            biomeCategory = BiomeCategory.TAIGA;
        } else if (temperature == 0.35f) {
            if (downfall == 0.4f) {
                biomeCategory = BiomeCategory.PLAINS;
            } else if (downfall == 0.5f) {
                biomeCategory = BiomeCategory.FOREST;
            } else if (downfall == 0.8f) {
                biomeCategory = BiomeCategory.PLAINS;
            }
        } else if (temperature == 0.4f) {
            biomeCategory = downfall == 0.7f ? BiomeCategory.PLAINS : BiomeCategory.COLD_FOREST;
        } else if (temperature == 0.45f) {
            biomeCategory = BiomeCategory.FOREST;
        } else if (temperature == 0.5f) {
            if (temperatureModifier == Biome.TemperatureModifier.FROZEN || generationSettings.m_186658_((PlacedFeature)AquaticPlacements.f_195219_.get()) || generationSettings.m_186658_((PlacedFeature)AquaticPlacements.f_195224_.get())) {
                biomeCategory = BiomeCategory.DEEP_COLD_OCEAN;
            } else if (generationSettings.m_186658_((PlacedFeature)AquaticPlacements.f_195227_.get())) {
                biomeCategory = BiomeCategory.WARM_OCEAN;
            } else if (generationSettings.m_186658_((PlacedFeature)AquaticPlacements.f_195218_.get())) {
                biomeCategory = BiomeCategory.LUKEWARM_OCEAN;
            } else if (generationSettings.m_186658_((PlacedFeature)AquaticPlacements.f_195223_.get())) {
                biomeCategory = BiomeCategory.DEEP_LUKEWARM_OCEAN;
            } else if (generationSettings.m_186658_((PlacedFeature)AquaticPlacements.f_195220_.get())) {
                biomeCategory = BiomeCategory.COLD_OCEAN;
            } else if (generationSettings.m_186658_((PlacedFeature)AquaticPlacements.f_195225_.get())) {
                biomeCategory = BiomeCategory.DEEP_COLD_OCEAN;
            } else if (generationSettings.m_186658_((PlacedFeature)MiscOverworldPlacements.f_195272_.get())) {
                biomeCategory = BiomeCategory.NONE;
            } else if (generationSettings.m_186658_((PlacedFeature)CavePlacements.f_195245_.get())) {
                biomeCategory = BiomeCategory.UNDERGROUND;
            } else if (precipitation == Biome.Precipitation.RAIN) {
                if (downfall == 0.8f) {
                    biomeCategory = BiomeCategory.MOUNTAIN;
                } else if (downfall == 0.5f) {
                    biomeCategory = BiomeCategory.RIVER;
                }
            } else if (precipitation == Biome.Precipitation.NONE) {
                biomeCategory = BiomeCategory.THEEND;
            }
        } else if (temperature == 0.6f) {
            if (downfall == 0.7f) {
                biomeCategory = BiomeCategory.PLAINS;
            } else if (downfall == 0.6f) {
                biomeCategory = BiomeCategory.FOREST;
            } else if (downfall == 0.05f) {
                biomeCategory = BiomeCategory.PLAINS;
            } else if (downfall == 0.9f) {
                biomeCategory = BiomeCategory.PLAINS;
            }
        } else if (temperature == 0.65f) {
            if (downfall == 0.7f) {
                biomeCategory = BiomeCategory.SWAMP;
            }
        } else if (temperature == 0.7f) {
            if (generationSettings.m_186658_((PlacedFeature)AquaticPlacements.f_195222_.get())) {
                biomeCategory = BiomeCategory.SWAMP;
            } else if (precipitation == Biome.Precipitation.RAIN) {
                if (downfall == 0.4f) {
                    biomeCategory = BiomeCategory.BEACH;
                } else if (downfall == 0.6f) {
                    biomeCategory = BiomeCategory.FOREST;
                } else if (downfall == 0.8f) {
                    biomeCategory = BiomeCategory.FOREST;
                }
            }
        } else if (temperature == 0.75f) {
            if (downfall == 0.8f) {
                biomeCategory = BiomeCategory.FOREST;
            }
        } else if (temperature == 0.8f) {
            if (mobSpawnSettings.getEntityTypes().contains(EntityType.f_20490_)) {
                biomeCategory = BiomeCategory.BEACH;
            } else if (generationSettings.m_186658_((PlacedFeature)AquaticPlacements.f_195222_.get())) {
                biomeCategory = BiomeCategory.SWAMP;
            } else if (generationSettings.m_186658_((PlacedFeature)CavePlacements.f_195240_.get()) || generationSettings.m_186658_((PlacedFeature)CavePlacements.f_236767_.get())) {
                biomeCategory = BiomeCategory.UNDERGROUND;
            } else if (generationSettings.m_186658_((PlacedFeature)VegetationPlacements.f_195449_.get())) {
                biomeCategory = BiomeCategory.PLAINS;
            } else if (specialEffects.m_47984_().isPresent() && (Integer)specialEffects.m_47984_().get() == 6530407) {
                biomeCategory = BiomeCategory.PLAINS;
            } else if (precipitation == Biome.Precipitation.RAIN) {
                if (downfall == 0.2f) {
                    biomeCategory = BiomeCategory.PLAINS;
                } else if (downfall == 0.275f) {
                    biomeCategory = BiomeCategory.LUSH_DESERT;
                } else if (downfall == 0.4f || downfall == 0.3f) {
                    biomeCategory = BiomeCategory.PLAINS;
                } else if (downfall == 0.5f || downfall == 0.6f || downfall == 0.8f || downfall == 0.85f || downfall == 0.9f) {
                    biomeCategory = BiomeCategory.FOREST;
                } else if (downfall == 0.7f) {
                    biomeCategory = BiomeCategory.PLAINS;
                }
            } else if (precipitation == Biome.Precipitation.NONE && (downfall == 0.4f || downfall == 0.8f)) {
                biomeCategory = BiomeCategory.THEEND;
            }
        } else if (temperature == 0.85f) {
            biomeCategory = downfall == 0.75f ? BiomeCategory.BEACH : BiomeCategory.DRYLAND;
        } else if (temperature == 0.9f) {
            if (generationSettings.m_186658_((PlacedFeature)VegetationPlacements.f_195446_.get())) {
                biomeCategory = BiomeCategory.MUSHROOM;
            }
            if (generationSettings.m_186658_((PlacedFeature)VegetationPlacements.f_195452_.get())) {
                biomeCategory = BiomeCategory.FOREST;
            } else if (precipitation == Biome.Precipitation.RAIN) {
                if (downfall == 0.5f) {
                    biomeCategory = BiomeCategory.LUSH_DESERT;
                } else if (downfall == 0.9f) {
                    biomeCategory = BiomeCategory.SWAMP;
                }
            }
        } else if (temperature == 0.95f) {
            if (generationSettings.m_186658_((PlacedFeature)VegetationPlacements.f_195458_.get())) {
                biomeCategory = specialEffects.m_47984_().isPresent() && (Integer)specialEffects.m_47984_().get() == 10145074 ? BiomeCategory.RAINFOREST : BiomeCategory.JUNGLE;
            } else if (downfall == 0.9f) {
                biomeCategory = BiomeCategory.SWAMP;
            } else if (downfall == 1.0f) {
                biomeCategory = BiomeCategory.JUNGLE;
            } else if (downfall == 0.3f) {
                biomeCategory = BiomeCategory.VOLCANIC;
            }
        } else if (temperature == 1.0f) {
            if (generationSettings.m_186658_((PlacedFeature)AquaticPlacements.f_195218_.get())) {
                biomeCategory = BiomeCategory.WARM_OCEAN;
            } else if (downfall == 0.3f) {
                biomeCategory = BiomeCategory.MOUNTAIN;
            } else if (downfall == 0.8f) {
                biomeCategory = BiomeCategory.JUNGLE;
            }
        } else if (temperature == 1.1f) {
            biomeCategory = BiomeCategory.SAVANNA;
        } else if (temperature == 1.2f) {
            biomeCategory = downfall == 0.0f ? BiomeCategory.SAVANNA : (downfall == 0.1f ? BiomeCategory.MESA : BiomeCategory.RAINFOREST);
        } else if (temperature == 2.0f) {
            biomeCategory = generationSettings.m_186658_((PlacedFeature)VegetationPlacements.f_195433_.get()) || generationSettings.m_186658_((PlacedFeature)VegetationPlacements.f_195468_.get()) ? BiomeCategory.SAVANNA : (generationSettings.m_186658_((PlacedFeature)MiscOverworldPlacements.f_195273_.get()) ? BiomeCategory.DESERT : (generationSettings.m_186658_((PlacedFeature)NetherPlacements.f_195299_.get()) ? BiomeCategory.NETHER : (generationSettings.m_186658_((PlacedFeature)VegetationPlacements.f_195453_.get()) ? BiomeCategory.MESA : (generationSettings.m_186658_((PlacedFeature)AquaticPlacements.f_195219_.get()) ? BiomeCategory.VOLCANIC : (specialEffects.m_47978_() == 12815488 ? BiomeCategory.DESERT : (generationSettings.m_186658_((PlacedFeature)VegetationPlacements.f_195401_.get()) ? BiomeCategory.DESERT : (downfall == 0.4f ? BiomeCategory.SAVANNA : BiomeCategory.NETHER)))))));
        }
        return biomeCategory;
    }

    static {
        BIOMES.put(BiomeCategory.DEEP_COLD_OCEAN, DEEP_COLD_OCEAN);
        BIOMES.put(BiomeCategory.COLD_DESERT, COLD_DESERT);
        BIOMES.put(BiomeCategory.COLD_FOREST, COLD_FOREST);
        BIOMES.put(BiomeCategory.COLD_OCEAN, COLD_OCEAN);
        BIOMES.put(BiomeCategory.ICY, ICY);
        BIOMES.put(BiomeCategory.OCEAN, OCEAN);
        BIOMES.put(BiomeCategory.WARM_OCEAN, WARM_OCEAN);
        BIOMES.put(BiomeCategory.LUKEWARM_OCEAN, LUKEWARM_OCEAN);
        BIOMES.put(BiomeCategory.DEEP_LUKEWARM_OCEAN, DEEP_LUKEWARM_OCEAN);
        BIOMES.put(BiomeCategory.BOG, BOG);
        BIOMES.put(BiomeCategory.RIVER, RIVER);
        BIOMES.put(BiomeCategory.TAIGA, TAIGA);
        BIOMES.put(BiomeCategory.EXTREME_HILLS, EXTREME_HILLS);
        BIOMES.put(BiomeCategory.MOUNTAIN, MOUNTAIN);
        BIOMES.put(BiomeCategory.BEACH, BEACH);
        BIOMES.put(BiomeCategory.FOREST, FOREST);
        BIOMES.put(BiomeCategory.SWAMP, SWAMP);
        BIOMES.put(BiomeCategory.UNDERGROUND, UNDERGROUND);
        BIOMES.put(BiomeCategory.MUSHROOM, MUSHROOM);
        BIOMES.put(BiomeCategory.PLAINS, PLAINS);
        BIOMES.put(BiomeCategory.LUSH_DESERT, LUSH_DESERT);
        BIOMES.put(BiomeCategory.DRYLAND, DRYLAND);
        BIOMES.put(BiomeCategory.RAINFOREST, RAINFOREST);
        BIOMES.put(BiomeCategory.JUNGLE, JUNGLE);
        BIOMES.put(BiomeCategory.VOLCANIC, VOLCANIC);
        BIOMES.put(BiomeCategory.SAVANNA, SAVANNA);
        BIOMES.put(BiomeCategory.MESA, MESA);
        BIOMES.put(BiomeCategory.DESERT, DESERT);
        BIOMES.put(BiomeCategory.NONE, NONE);
        BIOMES.put(BiomeCategory.THEEND, THEEND);
        BIOMES.put(BiomeCategory.NETHER, NETHER);
    }

    public static enum BiomeCategory {
        ICY,
        OCEAN,
        WARM_OCEAN,
        LUKEWARM_OCEAN,
        DEEP_LUKEWARM_OCEAN,
        COLD_OCEAN,
        DEEP_COLD_OCEAN,
        COLD_DESERT,
        COLD_FOREST,
        BOG,
        RIVER,
        TAIGA,
        EXTREME_HILLS,
        MOUNTAIN,
        BEACH,
        FOREST,
        SWAMP,
        UNDERGROUND,
        MUSHROOM,
        PLAINS,
        LUSH_DESERT,
        DRYLAND,
        RAINFOREST,
        JUNGLE,
        VOLCANIC,
        SAVANNA,
        MESA,
        DESERT,
        NONE,
        THEEND,
        NETHER,
        MISSING;

    }
}

