/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.capabilities;

import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.water.WaterInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class Water {
    private int waterLevel = 20;
    private float waterSaturationLevel = 5.0f;
    private float waterExhaustionLevel = 0.0f;

    public static Tag writeNBT(Capability<Water> capability, Water instance, Direction side) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("waterLevel", instance.getWaterLevel());
        tag.m_128350_("waterExhaustion", instance.getWaterExhaustionLevel());
        tag.m_128350_("waterSaturation", instance.getWaterSaturationLevel());
        return tag;
    }

    public static void readNBT(Capability<Water> capability, Water instance, Direction side, Tag nbt) {
        instance.setWaterLevel(((CompoundTag)nbt).m_128451_("waterLevel"));
        instance.setWaterExhaustionLevel(((CompoundTag)nbt).m_128457_("waterExhaustion"));
        instance.setWaterSaturationLevel(((CompoundTag)nbt).m_128457_("waterSaturation"));
    }

    public void setWaterLevel(int waterLevel) {
        this.waterLevel = waterLevel;
    }

    public void increaseWaterLevel(int level) {
        this.waterLevel = Math.min(this.waterLevel + level, 20);
    }

    public void increaseSaturationLevel(float level) {
        this.waterSaturationLevel = Math.min(this.waterSaturationLevel + level, 5.0f);
    }

    public void setWaterSaturationLevel(float waterSaturationLevel) {
        this.waterSaturationLevel = waterSaturationLevel;
    }

    public void setWaterExhaustionLevel(float waterExhaustionLevel) {
        this.waterExhaustionLevel = waterExhaustionLevel;
    }

    public void setWaterData(WaterInfo waterInfo) {
        this.setWaterLevel(waterInfo.getWaterLevel());
        this.setWaterSaturationLevel(waterInfo.getWaterSaturationLevel());
        this.setWaterExhaustionLevel(waterInfo.getWaterExhaustionLevel());
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public float getWaterExhaustionLevel() {
        return this.waterExhaustionLevel;
    }

    public float getWaterSaturationLevel() {
        return this.waterSaturationLevel;
    }

    public void checkWaterLevel(ServerPlayer player) {
        if (this.waterLevel <= 0) {
            player.m_6469_(new DamageSource("dehydration").m_19380_().m_19382_(), 1.0f);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        @Nonnull
        private final Water instance = new Water();
        private final LazyOptional<Water> handler = LazyOptional.of(this::getInstance);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CapabilityRegistry.WATER_CAPABILITY.orEmpty(cap, this.handler);
        }

        public Water getInstance() {
            return this.instance;
        }

        public Tag serializeNBT() {
            return Water.writeNBT(CapabilityRegistry.WATER_CAPABILITY, this.instance, null);
        }

        public void deserializeNBT(Tag nbt) {
            Water.readNBT(CapabilityRegistry.WATER_CAPABILITY, this.instance, null, nbt);
        }
    }
}

