/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.fluid;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import homeostatic.common.Hydration;
import java.lang.reflect.Type;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public record DrinkingFluid(ResourceLocation loc, int amount, float saturation, int potency, int duration, float chance) {
    public static Hydration getHydration(DrinkingFluid fluid) {
        return new Hydration(fluid.amount(), fluid.saturation(), fluid.potency(), fluid.duration(), fluid.chance());
    }

    public static class Serializer
    implements JsonDeserializer<DrinkingFluid>,
    JsonSerializer<DrinkingFluid> {
        public DrinkingFluid deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"data");
            return new DrinkingFluid(new ResourceLocation(json.get("fluid").getAsString()), json.get("amount").getAsInt(), json.get("saturation").getAsFloat(), json.get("effect_potency").getAsInt(), json.get("effect_duration").getAsInt(), json.get("effect_chance").getAsFloat());
        }

        public JsonElement serialize(DrinkingFluid drinkingFluid, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("fluid", drinkingFluid.loc().toString());
            json.addProperty("amount", (Number)drinkingFluid.amount());
            json.addProperty("saturation", (Number)Float.valueOf(drinkingFluid.saturation()));
            json.addProperty("effect_potency", (Number)drinkingFluid.potency());
            json.addProperty("effect_duration", (Number)drinkingFluid.duration());
            json.addProperty("effect_chance", (Number)Float.valueOf(drinkingFluid.chance()));
            return json;
        }
    }
}

