/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.block.BlockRadiation;
import homeostatic.common.block.BlockRadiationManager;
import homeostatic.data.integration.ModIntegration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;

public class RadiationBlocksProvider
implements DataProvider {
    private final Map<ResourceLocation, BlockRadiation> RADIATION_MAP = new HashMap<ResourceLocation, BlockRadiation>();
    private final DataGenerator dataGenerator;
    private final String modid;

    public RadiationBlocksProvider(DataGenerator dataGenerator, String modid) {
        this.dataGenerator = dataGenerator;
        this.modid = modid;
    }

    protected void registerRadiationBlocks() {
        this.add(ModIntegration.mcLoc("soul_campfire"), 8325.0);
        this.add(ModIntegration.mcLoc("campfire"), 5550.0);
        this.add(ModIntegration.mcLoc("soul_fire"), 1950.0);
        this.add(ModIntegration.mcLoc("blast_furnace"), 1800.0);
        this.add(ModIntegration.mcLoc("lava"), 1550.0);
        this.add(ModIntegration.mcLoc("fire"), 1300.0);
        this.add(ModIntegration.mcLoc("furnace"), 1300.0);
        this.add(ModIntegration.mcLoc("magma_block"), 1200.0);
        this.add(ModIntegration.mcLoc("smoker"), 1100.0);
        this.add(ModIntegration.mcLoc("soul_torch"), 525.0);
        this.add(ModIntegration.mcLoc("soul_wall_torch"), 525.0);
        this.add(ModIntegration.mcLoc("soul_lantern"), 525.0);
        this.add(ModIntegration.mcLoc("nether_portal"), 350.0);
        this.add(ModIntegration.mcLoc("torch"), 350.0);
        this.add(ModIntegration.mcLoc("wall_torch"), 350.0);
        this.add(ModIntegration.mcLoc("lantern"), 350.0);
        this.add(ModIntegration.bygLoc("cryptic_campfire"), 7250.0);
        this.add(ModIntegration.bygLoc("boric_campfire"), 6250.0);
        this.add(ModIntegration.bygLoc("cryptic_magma_block"), 1200.0);
        this.add(ModIntegration.bygLoc("boric_lantern"), 400.0);
        this.add(ModIntegration.bygLoc("cryptic_lantern"), 470.0);
    }

    protected void add(ResourceLocation loc, double maxRadiation) {
        this.RADIATION_MAP.put(loc, new BlockRadiation(loc, maxRadiation));
    }

    public String m_6055_() {
        return "Homeostatic - Block Radiation ";
    }

    public void m_213708_(CachedOutput pOutput) throws IOException {
        this.registerRadiationBlocks();
        Path output = this.dataGenerator.m_123916_();
        for (Map.Entry<ResourceLocation, BlockRadiation> entry : this.RADIATION_MAP.entrySet()) {
            Path blockRadiationPath = RadiationBlocksProvider.getPath(output, entry.getKey());
            try {
                DataProvider.m_236072_((CachedOutput)pOutput, (JsonElement)BlockRadiationManager.parseBlockRadiation(entry.getValue()), (Path)blockRadiationPath);
            }
            catch (IOException e) {
                Homeostatic.LOGGER.error("Couldn't save homeostatic block_radiation %s %s", (Object)blockRadiationPath, (Object)e);
            }
        }
    }

    private static Path getPath(Path output, ResourceLocation loc) {
        return output.resolve("data/" + loc.m_135827_() + "/environment/block_radiation/" + loc.m_135815_() + ".json");
    }
}

