/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data.recipe;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import homeostatic.Homeostatic;
import homeostatic.mixin.RecipeProviderAccessor;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;

public abstract class RecipeProviderBase
implements DataProvider {
    private final DataGenerator generator;

    protected RecipeProviderBase(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@Nonnull CachedOutput cache) throws IllegalStateException {
        Path path = this.generator.m_123916_();
        HashSet recipes = Sets.newHashSet();
        this.registerRecipes(provider -> {
            if (recipes.add(provider.m_6445_())) {
                JsonObject advancement = provider.m_5860_();
                RecipeProviderAccessor.callSaveRecipe(cache, provider.m_125966_(), path.resolve("data/" + provider.m_6445_().m_135827_() + "/recipes/" + provider.m_6445_().m_135815_() + ".json"));
                if (advancement != null) {
                    RecipeProviderBase.saveRecipeAdvancement(this.generator, cache, advancement, path.resolve("data/" + provider.m_6445_().m_135827_() + "/advancements/" + provider.m_6448_().m_135815_() + ".json"));
                }
            } else {
                throw new IllegalStateException("Duplicate recipe " + provider.m_6445_());
            }
        });
    }

    protected abstract void registerRecipes(Consumer<FinishedRecipe> var1);

    public static void saveRecipeAdvancement(DataGenerator gen, CachedOutput cache, JsonObject json, Path path) {
        ((RecipeProviderAccessor)new RecipeProvider(gen)).callSaveRecipeAdvancement(cache, json, path);
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromItem(ItemLike item) {
        return RecipeProviderAccessor.homeostatic_condition(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromTag(TagKey<Item> key) {
        return RecipeProviderAccessor.homeostatic_condition(ItemPredicate.Builder.m_45068_().m_204145_(key).m_45077_());
    }

    protected static void specialRecipe(Consumer<FinishedRecipe> consumer, SimpleRecipeSerializer<?> serializer) {
        ResourceLocation name = Registry.f_122865_.m_7981_(serializer);
        SpecialRecipeBuilder.m_126357_(serializer).m_126359_(consumer, Homeostatic.loc("dynamic/" + Objects.requireNonNull(name).m_135815_()).toString());
    }
}

