/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.integrations.jei;

import homeostatic.common.TagManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public final class ArmorEnhancementRecipeMaker {
    public static List<CraftingRecipe> createRecipes() {
        String group = "jei.armor.enhancement";
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        Ingredient wool = Ingredient.m_204132_(TagManager.Items.INSULATION);
        Ingredient waterproof = Ingredient.m_204132_(TagManager.Items.WATERPROOF);
        Ingredient radiation = Ingredient.m_204132_(TagManager.Items.RADIATION_PROTECTION);
        Registry.f_122827_.m_123024_().filter(ArmorItem.class::isInstance).forEach(armorItem -> {
            Ingredient baseArmorIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{armorItem.m_5456_()});
            ItemStack woolArmorStack = new ItemStack((ItemLike)armorItem);
            ItemStack waterproofArmorStack = new ItemStack((ItemLike)armorItem);
            ItemStack radiationArmorStack = new ItemStack((ItemLike)armorItem);
            CompoundTag woolArmorStackTag = woolArmorStack.m_41783_();
            CompoundTag waterproofArmorStackTag = waterproofArmorStack.m_41783_();
            CompoundTag radiationArmorStackTag = radiationArmorStack.m_41783_();
            NonNullList insulatedInputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseArmorIngredient, wool, wool, wool});
            NonNullList waterproofInputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseArmorIngredient, waterproof, waterproof, waterproof});
            NonNullList radiationInputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseArmorIngredient, radiation, radiation, radiation});
            if (woolArmorStackTag != null) {
                woolArmorStackTag.m_128379_("insulation", true);
                recipes.add((CraftingRecipe)new ShapelessRecipe(new ResourceLocation("homeostatic", group + ".insulated"), group, woolArmorStack, insulatedInputs));
            }
            if (waterproofArmorStackTag != null) {
                waterproofArmorStackTag.m_128379_("waterproof", true);
                recipes.add((CraftingRecipe)new ShapelessRecipe(new ResourceLocation("homeostatic", group + ".waterproof"), group, waterproofArmorStack, waterproofInputs));
            }
            if (radiationArmorStackTag != null) {
                radiationArmorStackTag.m_128379_("radiation_protection", true);
                recipes.add((CraftingRecipe)new ShapelessRecipe(new ResourceLocation("homeostatic", group + ".radiation_resistance"), group, radiationArmorStack, radiationInputs));
            }
        });
        return recipes;
    }
}

