/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.proxy;

import homeostatic.Homeostatic;
import homeostatic.common.biome.BiomeRegistry;
import homeostatic.common.block.HomeostaticBlocks;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.recipe.HomeostaticRecipes;
import homeostatic.config.ConfigHandler;
import homeostatic.network.NetworkHandler;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="homeostatic")
public class CommonProxy {
    public void start() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ConfigHandler.init();
        this.registerListeners(bus);
        BiomeRegistry.init();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::serverStart);
    }

    public void registerListeners(IEventBus bus) {
        bus.register(RegistryListener.class);
    }

    public void serverStart(ServerStartedEvent event) {
        Registry biomeRegistry = BuiltinRegistries.f_123865_;
        for (Map.Entry entry : biomeRegistry.m_6579_()) {
            ResourceKey biomeResourceKey = (ResourceKey)entry.getKey();
            ResourceLocation biomeName = biomeResourceKey.m_135782_();
            Biome biome = (Biome)entry.getValue();
            Consumer<String> error = x -> Homeostatic.LOGGER.error("error getting holder for %s", (Object)biomeName);
            BiomeRegistry.BiomeCategory biomeCategory = BiomeRegistry.getBiomeCategory((Holder<Biome>)((Holder)biomeRegistry.m_214185_(biomeResourceKey).getOrThrow(false, error)));
            Homeostatic.LOGGER.debug("Biome: " + biomeName + "\npreciptitation=" + biome.m_47530_() + "\ntemperature=" + biome.m_47554_() + "\ntemperatureModifier=" + biome.getModifiedClimateSettings().f_47682_() + "\ndownfall=" + biome.m_47548_() + "\nbiomeCategory=" + biomeCategory);
        }
    }

    public static final class RegistryListener {
        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            NetworkHandler.init();
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerEvent(RegisterEvent event) {
            event.register(Registry.f_122900_, HomeostaticEffects::init);
            event.register(Registry.f_122904_, HomeostaticItems::init);
            event.register(Registry.f_122901_, HomeostaticBlocks::init);
            event.register(Registry.f_122899_, HomeostaticFluids::init);
            event.register(((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getRegistryKey(), HomeostaticFluids::initTypes);
            event.register(Registry.f_122915_, HomeostaticRecipes::init);
        }
    }
}

