/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.wetness.WetnessInfo;
import homeostatic.network.NetworkHandler;
import homeostatic.network.WetnessData;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import net.minecraftforge.network.PacketDistributor;

public class WetnessHelper {
    public static void updateWetnessInfo(ServerPlayer sp, float moistureLevel, boolean increase) {
        if (sp.f_8941_.m_9290_() != GameType.SURVIVAL) {
            return;
        }
        sp.getCapability(CapabilityRegistry.WETNESS_CAPABILITY).ifPresent(data -> {
            WetnessInfo wetnessInfo = new WetnessInfo(data.getWetnessLevel(), data.getMoistureLevel());
            AtomicInteger waterproofing = new AtomicInteger();
            sp.m_6168_().forEach(armorItem -> {
                CompoundTag tags = armorItem.m_41783_();
                if (tags != null && tags.m_128441_("waterproof")) {
                    waterproofing.addAndGet(5);
                }
            });
            if (increase) {
                wetnessInfo.increaseMoisture(moistureLevel, waterproofing.get());
            } else {
                wetnessInfo.decreaseMoisture(moistureLevel);
            }
            data.setWetnessData(wetnessInfo);
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new WetnessData(wetnessInfo));
        });
    }

    public static int getWetness(ServerPlayer sp) {
        AtomicInteger wetness = new AtomicInteger();
        sp.getCapability(CapabilityRegistry.WETNESS_CAPABILITY).ifPresent(data -> wetness.set(data.getWetnessLevel()));
        return wetness.get();
    }
}

