/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.block;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public record BlockRadiation(ResourceLocation loc, double maxRadiation) {
    public ResourceLocation getLocation() {
        return this.loc;
    }

    public double getMaxRadiation() {
        return this.maxRadiation;
    }

    public double getBlockRadiation(double distance, boolean obscured, int y) {
        double radiation = distance <= 1.0 ? this.getMaxRadiation() : this.getMaxRadiation() / distance;
        if (y > 0 && y < 5) {
            radiation *= (double)(4 - y) * 0.25;
        }
        if (obscured) {
            radiation *= 0.9;
        }
        return Math.min(radiation, this.getMaxRadiation());
    }

    public double getBlockRadiation(double distance, boolean obscured, double amount, int y) {
        double radiation = 0.0;
        if (amount <= 0.0) {
            return radiation;
        }
        radiation = distance <= 1.0 ? this.getMaxRadiation() : this.getMaxRadiation() * amount / distance;
        if (y > 0 && y < 5) {
            radiation *= (double)(4 - y) * 0.25;
        }
        if (obscured) {
            radiation *= 0.9;
        }
        return Math.min(radiation, this.getMaxRadiation());
    }

    public static class Serializer
    implements JsonDeserializer<BlockRadiation>,
    JsonSerializer<BlockRadiation> {
        public BlockRadiation deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"data");
            return new BlockRadiation(new ResourceLocation(json.get("block").getAsString()), json.get("max_radiation").getAsDouble());
        }

        public JsonElement serialize(BlockRadiation blockRadiation, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("block", blockRadiation.getLocation().toString());
            json.addProperty("max_radiation", (Number)blockRadiation.getMaxRadiation());
            return json;
        }
    }
}

