/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.fluid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.fluid.DrinkingFluid;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DrinkingFluidManager
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, DrinkingFluid> FLUIDS = new HashMap<ResourceLocation, DrinkingFluid>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DrinkingFluid.class, (Object)new DrinkingFluid.Serializer()).create();
    private static DrinkingFluidManager INSTANCE;

    public DrinkingFluidManager() {
        super(GSON, "environment/fluids");
    }

    public static JsonElement parseDrinkingFluid(DrinkingFluid drinkingFluid) {
        return GSON.toJsonTree((Object)drinkingFluid);
    }

    public static DrinkingFluid get(ResourceLocation loc) {
        return FLUIDS.get(loc);
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        FLUIDS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            try {
                DrinkingFluid drinkingFluid = (DrinkingFluid)GSON.fromJson(entry.getValue(), DrinkingFluid.class);
                FLUIDS.put(drinkingFluid.loc(), drinkingFluid);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse drinking fluid %s %s", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded %d drinking fluids", (Object)FLUIDS.size());
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        INSTANCE = new DrinkingFluidManager();
        event.addListener((PreparableReloadListener)INSTANCE);
    }
}

