/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.fluid;

import homeostatic.Homeostatic;
import homeostatic.common.block.HomeostaticBlocks;
import homeostatic.common.item.HomeostaticItems;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegisterEvent;

public final class HomeostaticFluids {
    public static FluidType PURIFIED_WATER_TYPE;
    public static FlowingFluid PURIFIED_WATER;
    public static FlowingFluid PURIFIED_WATER_FLOWING;
    public static final ResourceLocation STILL_FLUID_TEXTURE;
    public static final ResourceLocation FLOWING_FLUID_TEXTURE;

    public static ForgeFlowingFluid.Properties fluidProperties() {
        return new ForgeFlowingFluid.Properties(() -> PURIFIED_WATER_TYPE, () -> PURIFIED_WATER, () -> PURIFIED_WATER_FLOWING).bucket(() -> HomeostaticItems.PURIFIED_WATER_BUCKET).block(() -> HomeostaticBlocks.PURIFIED_WATER_FLUID).slopeFindDistance(3).explosionResistance(100.0f);
    }

    public static void init(RegisterEvent.RegisterHelper<Fluid> registerHelper) {
        PURIFIED_WATER = new ForgeFlowingFluid.Source(HomeostaticFluids.fluidProperties());
        PURIFIED_WATER_FLOWING = new ForgeFlowingFluid.Flowing(HomeostaticFluids.fluidProperties());
        registerHelper.register("purified_water_flowing", (Object)PURIFIED_WATER_FLOWING);
        registerHelper.register("purified_water", (Object)PURIFIED_WATER);
    }

    public static void initTypes(RegisterEvent.RegisterHelper<FluidType> registryHelper) {
        PURIFIED_WATER_TYPE = new FluidType(FluidType.Properties.create().viscosity(1000).lightLevel(3).density(4000).rarity(Rarity.UNCOMMON).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_)){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return STILL_FLUID_TEXTURE;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return FLOWING_FLUID_TEXTURE;
                    }
                });
            }
        };
        registryHelper.register("purified_water_type", (Object)PURIFIED_WATER_TYPE);
    }

    static {
        STILL_FLUID_TEXTURE = Homeostatic.loc("block/fluid/still_water");
        FLOWING_FLUID_TEXTURE = Homeostatic.loc("block/fluid/flowing_water");
    }
}

