/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import homeostatic.Homeostatic;
import homeostatic.common.TagManager;
import homeostatic.common.item.DrinkableItem;
import homeostatic.util.RegistryHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DrinkableItemManager
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, DrinkableItem> ITEMS = new HashMap<ResourceLocation, DrinkableItem>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DrinkableItem.class, (Object)new DrinkableItem.Serializer()).create();
    private static DrinkableItemManager INSTANCE;
    private static final DrinkableItem FRUIT;

    public DrinkableItemManager() {
        super(GSON, "environment/drinkable");
    }

    public static JsonElement parseDrinkableItem(DrinkableItem drinkableItem) {
        return GSON.toJsonTree((Object)drinkableItem);
    }

    public static DrinkableItem get(ItemStack stack) {
        ResourceLocation loc = RegistryHelper.getRegistry(Registries.f_256913_).m_7981_((Object)stack.m_41720_());
        DrinkableItem drinkableItem = ITEMS.get(loc);
        if (drinkableItem != null) {
            return drinkableItem;
        }
        if (stack.m_204117_(TagManager.Items.FRUITS)) {
            return FRUIT;
        }
        return null;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        ITEMS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            try {
                DrinkableItem drinkableItem = (DrinkableItem)GSON.fromJson(entry.getValue(), DrinkableItem.class);
                ITEMS.put(drinkableItem.loc(), drinkableItem);
            }
            catch (Exception e) {
                Homeostatic.LOGGER.error("Couldn't parse drinkable item %s %s", (Object)entry.getKey(), (Object)e);
            }
        }
        Homeostatic.LOGGER.info("Loaded %d drinkable items", (Object)ITEMS.size());
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        INSTANCE = new DrinkableItemManager();
        event.addListener((PreparableReloadListener)INSTANCE);
    }

    static {
        FRUIT = new DrinkableItem(new ResourceLocation("forge:fruits"), 2, 0.6f, 0, 0, 0.0f);
    }
}

