/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import homeostatic.Homeostatic;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.HomeostaticBook;
import homeostatic.common.item.LeatherFlask;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.RegisterEvent;

public final class HomeostaticItems {
    private static final Map<ResourceLocation, Item> ALL = new LinkedHashMap<ResourceLocation, Item>();
    public static RegisterEvent.RegisterHelper<Item> ITEM_REGISTRY;
    public static Item LEATHER_FLASK;
    public static Item PURIFIED_WATER_BUCKET;
    public static Item WATER_FILTER;
    public static Item BOOK;
    public static Item THERMOMETER;

    public static void init(RegisterEvent.RegisterHelper<Item> registryHelper) {
        ITEM_REGISTRY = registryHelper;
        LEATHER_FLASK = HomeostaticItems.registerItem("leather_flask", (Item)new LeatherFlask(new Item.Properties().m_41487_(1).setNoRepair(), 5000));
        PURIFIED_WATER_BUCKET = HomeostaticItems.registerItem("purified_water_bucket", (Item)new BucketItem((Fluid)HomeostaticFluids.PURIFIED_WATER, new Item.Properties().m_41487_(1)));
        WATER_FILTER = HomeostaticItems.registerItem("water_filter", new Item(new Item.Properties()));
        BOOK = HomeostaticItems.registerItem("book", new HomeostaticBook(new Item.Properties(), "book"));
        THERMOMETER = HomeostaticItems.registerItem("thermometer", new Item(new Item.Properties()));
    }

    public static Item registerItem(String name, Item item) {
        ResourceLocation loc = Homeostatic.loc(name);
        ITEM_REGISTRY.register(loc, (Object)item);
        ALL.put(loc, item);
        return item;
    }

    public static Map<ResourceLocation, Item> getAll() {
        return ALL;
    }
}

