/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.temperature;

import com.mojang.datafixers.util.Pair;
import homeostatic.common.biome.BiomeData;
import homeostatic.common.biome.BiomeRegistry;
import homeostatic.common.temperature.Environment;
import homeostatic.common.temperature.EnvironmentInfo;
import homeostatic.mixin.ServerLevelAccessor;
import homeostatic.util.TempHelper;
import homeostatic.util.WetnessHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.fml.ModList;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.ServerConfig;

public class EnvironmentData {
    private boolean isSubmerged;
    private boolean isPartialSubmersion;
    private double relativeHumidity;
    private float airTemperature;
    private float waterTemperature;
    private float localTemperature;
    private double envRadiation;

    public EnvironmentData(ServerPlayer sp, BlockPos pos, Holder<Biome> biome, ServerLevel world) {
        LevelData info = world.m_6106_();
        ArrayList<Pair> biomes = new ArrayList<Pair>();
        int chunkRange = 3;
        float accumulatedDryTemp = 0.0f;
        float accumulatedHumidity = 0.0f;
        float moisture = 0.0f;
        EnvironmentInfo envData = Environment.get(world, sp);
        boolean isUnderground = envData.isUnderground();
        boolean isSheltered = envData.isSheltered();
        double waterVolume = envData.getWaterVolume();
        Holder.Reference lushBiome = world.m_8891_().m_175515_(Registries.f_256952_).m_246971_(Biomes.f_151785_);
        this.envRadiation = envData.getRadiation();
        this.isPartialSubmersion = !sp.m_5842_() && sp.m_20069_() && sp.m_20071_();
        boolean bl = this.isSubmerged = sp.m_5842_() && sp.m_20069_() && sp.m_20071_();
        if (this.isSubmerged) {
            moisture = 20.0f;
        } else if (this.isPartialSubmersion) {
            moisture = 10.0f;
        } else if (sp.m_20071_()) {
            moisture = 0.5f;
        }
        if (moisture > 0.0f) {
            WetnessHelper.updateWetnessInfo(sp, moisture, true);
        }
        if (!this.isPartialSubmersion) {
            this.isPartialSubmersion = sp.m_146900_().m_60767_().equals(Material.f_76305_);
        }
        if (isSheltered || isUnderground) {
            biomes.add(Pair.of((Object)lushBiome, (Object)pos));
        }
        if (!isUnderground || this.isSubmerged) {
            for (int x = -chunkRange; x <= chunkRange; ++x) {
                for (int z = -chunkRange; z <= chunkRange; ++z) {
                    BlockPos chunkPos = pos.m_7918_(x * 16, 0, z * 16);
                    if (!world.m_46749_(chunkPos)) continue;
                    biomes.add(Pair.of((Object)world.m_204166_(chunkPos), (Object)chunkPos));
                }
            }
        }
        for (Pair pair : biomes) {
            Holder chunkBiome = (Holder)pair.getFirst();
            BlockPos chunkPos = (BlockPos)pair.getSecond();
            float chunkTemp = ((Biome)chunkBiome.m_203334_()).m_47528_(chunkPos);
            accumulatedDryTemp += isUnderground ? chunkTemp : EnvironmentData.getSeasonAdjustedTemperature(world, (Holder<Biome>)chunkBiome, chunkTemp);
            if (!info.m_5470_().m_46207_(GameRules.f_46150_)) continue;
            double chunkHumidity = EnvironmentData.getBiomeHumidity(world, (Holder<Biome>)chunkBiome);
            accumulatedHumidity = (float)((double)accumulatedHumidity + chunkHumidity);
        }
        this.relativeHumidity = accumulatedHumidity / (float)biomes.size();
        float dayNightOffset = isUnderground ? 0.0f : EnvironmentData.getDayNightOffset(world, biome, this.relativeHumidity);
        float dryTemp = accumulatedDryTemp / (float)biomes.size() + dayNightOffset;
        float wetTemp = (float)TempHelper.getHeatIndex(dryTemp, this.relativeHumidity);
        float blackGlobeTemp = (float)this.getBlackGlobeTemp(world, pos, dryTemp, this.relativeHumidity);
        this.airTemperature = isSheltered || isUnderground ? wetTemp * 0.7f + blackGlobeTemp * 0.3f : wetTemp * 0.7f + blackGlobeTemp * 0.2f + dryTemp * 0.1f;
        if (this.isSubmerged || this.isPartialSubmersion) {
            this.waterTemperature = EnvironmentData.getWaterTemperature(this.airTemperature, waterVolume);
            this.localTemperature = this.isSubmerged ? this.waterTemperature : this.waterTemperature * 0.7f + this.airTemperature * 0.3f;
        } else {
            this.localTemperature = this.airTemperature;
        }
    }

    public boolean isSubmerged() {
        return this.isSubmerged;
    }

    public boolean isPartialSubmersion() {
        return this.isPartialSubmersion;
    }

    public double getRelativeHumidity() {
        return this.relativeHumidity;
    }

    public float getLocalTemperature() {
        return this.localTemperature;
    }

    public double getEnvRadiation() {
        return this.envRadiation;
    }

    private double getBlackGlobeTemp(ServerLevel world, BlockPos pos, float dryTemp, double relativeHumidity) {
        this.envRadiation += EnvironmentData.getSunRadiation(world, pos);
        return TempHelper.getBlackGlobe(this.envRadiation, dryTemp, relativeHumidity);
    }

    private static double getBiomeHumidity(ServerLevel world, Holder<Biome> biome) {
        double biomeHumidity;
        LevelData info = world.m_6106_();
        ServerLevelAccessor serverLevel = (ServerLevelAccessor)world;
        ServerLevelData serverInfo = serverLevel.getServerLevelData();
        double maxRH = EnvironmentData.getMaxBiomeHumidity(biome);
        double minRH = maxRH - 20.0;
        if (((Biome)biome.m_203334_()).m_47530_() != Biome.Precipitation.NONE) {
            int nextRain = serverInfo.m_6537_();
            biomeHumidity = info.m_6533_() ? maxRH : (nextRain > 0 && nextRain <= 12000 ? minRH + (double)(20.0f * (1.0f - (float)nextRain / 12000.0f)) : minRH);
        } else {
            biomeHumidity = minRH;
        }
        return biomeHumidity;
    }

    private static double getSunRadiation(ServerLevel world, BlockPos pos) {
        double radiation = 0.0;
        double sunlight = world.m_45517_(LightLayer.SKY, pos.m_7494_()) - world.m_7445_();
        float f = world.m_46490_(1.0f);
        if (sunlight > 0.0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            sunlight *= (double)Mth.m_14089_((float)f);
        }
        return Math.max(radiation += sunlight * 100.0, 0.0);
    }

    private static double getMaxBiomeHumidity(Holder<Biome> biome) {
        BiomeData biomeData = BiomeRegistry.getDataForBiome(biome);
        return biomeData.getHumidity(biome);
    }

    private static float getWaterTemperature(float airTemperature, double waterVolume) {
        float waterTemp;
        float baseWaterTemp = 0.663f;
        if (airTemperature >= 1.108f) {
            float increase = 0.1f + (float)(1.0 - waterVolume) * 0.35f;
            waterTemp = baseWaterTemp + (airTemperature - 1.108f) * increase;
        } else {
            waterTemp = Math.max(baseWaterTemp - (1.108f - airTemperature) * 0.5f, 0.072f);
        }
        return waterTemp;
    }

    private static float getDayNightOffset(ServerLevel world, Holder<Biome> biome, double relativeHumidity) {
        BiomeData biomeData = BiomeRegistry.getDataForBiome(biome);
        long time = world.m_46468_() % 24000L;
        float maxTemp = biomeData.getDayNightOffset(((Biome)biome.m_203334_()).m_47530_());
        if (maxTemp == 0.0f) {
            return maxTemp;
        }
        float increaseTemp = maxTemp / 10000.0f;
        float decreaseTemp = maxTemp / 14000.0f;
        float humidityOffset = 1.0f - (float)(relativeHumidity / 100.0);
        float offset = time > 23000L ? (float)(24001L - time) * increaseTemp : (time < 9001L ? (float)(time + 1000L) * increaseTemp : maxTemp - (float)(time - 9000L) * decreaseTemp);
        return offset * humidityOffset;
    }

    private static float getSeasonAdjustedTemperature(ServerLevel world, Holder<Biome> biome, float biomeTemp) {
        if (ModList.get().isLoaded("sereneseasons")) {
            ResourceKey worldKey = world.m_46472_();
            boolean seasonEffects = ServerConfig.isDimensionWhitelisted((ResourceKey)world.m_46472_());
            if (seasonEffects && worldKey.m_135782_().toString().contains(BuiltinDimensionTypes.f_223538_.m_135782_().toString())) {
                BiomeData biomeData = BiomeRegistry.getDataForBiome(biome);
                float lateSummerOffset = 0.022289157f * 5.0f;
                int subSeason = SeasonHelper.getSeasonState((Level)world).getSubSeason().ordinal();
                float variation = biomeData.getSeasonVariation(((Biome)biome.m_203334_()).m_47530_()) / 2.0f;
                int season = subSeason + 9 <= 12 ? subSeason + 9 : subSeason - 3;
                double temp = (double)variation * Math.cos((double)(season - 1) * Math.PI / 6.0) + (double)biomeTemp;
                if (season == 2) {
                    temp += (double)lateSummerOffset;
                }
                return (float)temp;
            }
        }
        return biomeTemp;
    }

    public String toString() {
        return "EnvironmentData{isSubmerged=" + this.isSubmerged + ", isPartialSubmersion=" + this.isPartialSubmersion + ", relativeHumidity=" + this.relativeHumidity + ", airTemperature=" + this.airTemperature + ", waterTemperature=" + this.waterTemperature + ", localTemperature=" + this.localTemperature + ", envRadiation=" + this.envRadiation + "}";
    }
}

