/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import homeostatic.data.DrinkableItemsProvider;
import homeostatic.data.DrinkingFluidsProvider;
import homeostatic.data.ModBlockStateProvider;
import homeostatic.data.ModBlockTagsProvider;
import homeostatic.data.ModFluidTagsProvider;
import homeostatic.data.ModItemModelProvider;
import homeostatic.data.ModItemTagsProvider;
import homeostatic.data.ModLanguageProvider;
import homeostatic.data.RadiationBlocksProvider;
import homeostatic.data.integration.patchouli.ModBookProvider;
import homeostatic.data.recipe.ModRecipesProvider;
import homeostatic.data.recipe.SpecialRecipeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="homeostatic", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        ModBlockTagsProvider blockTags = new ModBlockTagsProvider(gen.getPackOutput(), event.getLookupProvider(), existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(gen.getPackOutput(), event.getLookupProvider(), blockTags, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModFluidTagsProvider(gen.getPackOutput(), event.getLookupProvider(), existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModRecipesProvider(gen.getPackOutput()));
        gen.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(gen.getPackOutput(), existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(gen.getPackOutput(), existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new RadiationBlocksProvider(gen.getPackOutput()));
        gen.addProvider(event.includeServer(), (DataProvider)new DrinkingFluidsProvider(gen.getPackOutput()));
        gen.addProvider(event.includeServer(), (DataProvider)new DrinkableItemsProvider(gen.getPackOutput()));
        gen.addProvider(event.includeServer(), (DataProvider)new ModBookProvider(gen.getPackOutput()));
        gen.addProvider(event.includeClient(), (DataProvider)new ModLanguageProvider(gen.getPackOutput()));
        gen.addProvider(event.includeServer(), (DataProvider)new SpecialRecipeProvider(gen.getPackOutput()));
    }
}

