/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import com.google.gson.JsonElement;
import homeostatic.common.item.DrinkableItem;
import homeostatic.common.item.DrinkableItemManager;
import homeostatic.data.integration.ModIntegration;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DrinkableItemsProvider
implements DataProvider {
    private final Map<ResourceLocation, DrinkableItem> DRINKABLE_ITEMS = new HashMap<ResourceLocation, DrinkableItem>();
    private final PackOutput packOutput;

    public DrinkableItemsProvider(@NotNull PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    protected void addDrinkableItems() {
        this.add(ModIntegration.mcLoc("honey_bottle"), 4, 1.0f, 0, 0, 0.0f);
        this.add(ModIntegration.mcLoc("milk_bucket"), 9, 2.1f, 0, 0, 0.0f);
        this.add(ModIntegration.mcLoc("enchanted_golden_apple"), 9, 2.1f, 0, 0, 0.0f);
        this.add(ModIntegration.mcLoc("golden_apple"), 6, 1.2f, 0, 0, 0.0f);
        this.addSoup(ModIntegration.mcLoc("beetroot_soup"));
        this.addSoup(ModIntegration.mcLoc("mushroom_stew"));
        this.addSoup(ModIntegration.mcLoc("rabbit_stew"));
        this.addBerries(ModIntegration.mcLoc("glow_berries"));
        this.addBerries(ModIntegration.mcLoc("sweet_berries"));
        this.addFruit(ModIntegration.mcLoc("melon_slice"));
        this.addFruit(ModIntegration.mcLoc("apple"));
        this.add(ModIntegration.mcLoc("suspicious_stew"), 1, 0.0f, 45, 200, 0.3f);
        this.add(ModIntegration.mcLoc("poisonous_potato"), 1, 0.0f, 45, 200, 0.2f);
        this.addVeggie(ModIntegration.mcLoc("beetroot"));
        this.addVeggie(ModIntegration.mcLoc("carrot"));
        this.addVeggie(ModIntegration.mcLoc("potato"));
        this.addCake(ModIntegration.mcLoc("cake"));
        this.addVeggie(ModIntegration.mcLoc("baked_potato"));
        this.addVeggie(ModIntegration.mcLoc("golden_carrot"));
        this.addFruit(ModIntegration.mcLoc("glistering_melon_slice"));
        this.add(ModIntegration.bygLoc("holly_berries"), 1, 0.0f, 45, 200, 0.5f);
        this.addBerries(ModIntegration.bygLoc("nightshade_berries"));
        this.addBerries(ModIntegration.bygLoc("blueberries"));
        this.addPie(ModIntegration.bygLoc("nightshade_berry_pie"));
        this.addPie(ModIntegration.bygLoc("blueberry_pie"));
        this.add(ModIntegration.bygLoc("crimson_berries"), 1, 0.0f, 0, 0, 0.0f);
        this.add(ModIntegration.bygLoc("crimson_berry_pie"), 2, 0.0f, 0, 0, 0.0f);
        this.addFruit(ModIntegration.bygLoc("baobab_fruit"));
        this.addFruit(ModIntegration.bygLoc("green_apple"));
        this.addPie(ModIntegration.bygLoc("green_apple_pie"));
        this.add(ModIntegration.bygLoc("aloe_vera_juice"), 4, 1.0f, 0, 0, 0.0f);
        this.add(ModIntegration.bygLoc("white_puffball_cap"), 1, 0.0f, 0, 0, 0.0f);
        this.add(ModIntegration.bygLoc("cooked_white_puffball_cap"), 1, 0.0f, 0, 0, 0.0f);
        this.add(ModIntegration.bygLoc("white_puffball_stew"), 2, 0.0f, 0, 0, 0.0f);
        this.addDrink(ModIntegration.croptopiaLoc("rum"));
        this.addDrink(ModIntegration.croptopiaLoc("beer"));
        this.addDrink(ModIntegration.croptopiaLoc("wine"));
        this.addDrink(ModIntegration.croptopiaLoc("pumpkin_spice_latte"));
        this.addDrink(ModIntegration.croptopiaLoc("crema"));
        this.addDrink(ModIntegration.croptopiaLoc("apple_juice"));
        this.addDrink(ModIntegration.croptopiaLoc("orange_juice"));
        this.addDrink(ModIntegration.croptopiaLoc("grape_juice"));
        this.addDrink(ModIntegration.croptopiaLoc("cranberry_juice"));
        this.addDrink(ModIntegration.croptopiaLoc("saguaro_juice"));
        this.addDrink(ModIntegration.croptopiaLoc("tomato_juice"));
        this.addDrink(ModIntegration.croptopiaLoc("pineapple_juice"));
        this.addDrink(ModIntegration.croptopiaLoc("lemonade"));
        this.addDrink(ModIntegration.croptopiaLoc("soy_milk"));
        this.addDrink(ModIntegration.croptopiaLoc("tea"));
        this.addDrink(ModIntegration.croptopiaLoc("limeade"));
        this.addDrink(ModIntegration.croptopiaLoc("horchata"));
        this.addDrink(ModIntegration.croptopiaLoc("mead"));
        this.addDrink(ModIntegration.croptopiaLoc("coffee"));
        this.addBerries(ModIntegration.croptopiaLoc("elderberry"));
        this.addBerries(ModIntegration.croptopiaLoc("blackberry"));
        this.addBerries(ModIntegration.croptopiaLoc("cranberry"));
        this.addBerries(ModIntegration.croptopiaLoc("raspberry"));
        this.addBerries(ModIntegration.croptopiaLoc("blueberry"));
        this.addBerries(ModIntegration.croptopiaLoc("strawberry"));
        this.addBerries(ModIntegration.croptopiaLoc("grape"));
        this.addJam(ModIntegration.croptopiaLoc("elderberry_jam"));
        this.addJam(ModIntegration.croptopiaLoc("blackberry_jam"));
        this.addJam(ModIntegration.croptopiaLoc("strawberry_jam"));
        this.addJam(ModIntegration.croptopiaLoc("blueberry_jam"));
        this.addJam(ModIntegration.croptopiaLoc("raspberry_jam"));
        this.addJam(ModIntegration.croptopiaLoc("yam_jam"));
        this.addJam(ModIntegration.croptopiaLoc("grape_jam"));
        this.addJam(ModIntegration.croptopiaLoc("peach_jam"));
        this.addJam(ModIntegration.croptopiaLoc("apricot_jam"));
        this.addJam(ModIntegration.croptopiaLoc("cherry_jam"));
        this.addJam(ModIntegration.croptopiaLoc("peanut_butter_and_jam"));
        this.addJam(ModIntegration.croptopiaLoc("toast_with_jam"));
        this.addShake(ModIntegration.croptopiaLoc("kale_smoothie"));
        this.addShake(ModIntegration.croptopiaLoc("fruit_smoothie"));
        this.addShake(ModIntegration.croptopiaLoc("strawberry_smoothie"));
        this.addShake(ModIntegration.croptopiaLoc("banana_smoothie"));
        this.addShake(ModIntegration.croptopiaLoc("chocolate_milkshake"));
        this.addShake(ModIntegration.croptopiaLoc("eton_mess"));
        this.addFruit(ModIntegration.croptopiaLoc("lemon"));
        this.addFruit(ModIntegration.croptopiaLoc("lime"));
        this.addFruit(ModIntegration.croptopiaLoc("honeydew"));
        this.addFruit(ModIntegration.croptopiaLoc("kumquat"));
        this.addFruit(ModIntegration.croptopiaLoc("nectarine"));
        this.addFruit(ModIntegration.croptopiaLoc("fig"));
        this.addFruit(ModIntegration.croptopiaLoc("kiwi"));
        this.addFruit(ModIntegration.croptopiaLoc("orange"));
        this.addFruit(ModIntegration.croptopiaLoc("zucchini"));
        this.addFruit(ModIntegration.croptopiaLoc("plum"));
        this.addFruit(ModIntegration.croptopiaLoc("persimmon"));
        this.addFruit(ModIntegration.croptopiaLoc("pear"));
        this.addFruit(ModIntegration.croptopiaLoc("candied_kumquats"));
        this.addFruit(ModIntegration.croptopiaLoc("banana"));
        this.addFruit(ModIntegration.croptopiaLoc("cantaloupe"));
        this.addFruit(ModIntegration.croptopiaLoc("cherry"));
        this.addFruit(ModIntegration.croptopiaLoc("date"));
        this.addFruit(ModIntegration.croptopiaLoc("currant"));
        this.addFruit(ModIntegration.croptopiaLoc("grapefruit"));
        this.addFruit(ModIntegration.croptopiaLoc("peach"));
        this.addFruit(ModIntegration.croptopiaLoc("saguaro"));
        this.addFruit(ModIntegration.croptopiaLoc("mango"));
        this.addFruit(ModIntegration.croptopiaLoc("dragonfruit"));
        this.addFruit(ModIntegration.croptopiaLoc("apricot"));
        this.addFruit(ModIntegration.croptopiaLoc("pineapple"));
        this.addFruit(ModIntegration.croptopiaLoc("starfruit"));
        this.addPie(ModIntegration.croptopiaLoc("pecan_pie"));
        this.addPie(ModIntegration.croptopiaLoc("apple_pie"));
        this.addPie(ModIntegration.croptopiaLoc("cherry_pie"));
        this.addPie(ModIntegration.croptopiaLoc("banana_cream_pie"));
        this.addPie(ModIntegration.croptopiaLoc("rhubarb_pie"));
        this.addIcecream(ModIntegration.croptopiaLoc("mango_ice_cream"));
        this.addIcecream(ModIntegration.croptopiaLoc("rum_raisin_ice_cream"));
        this.addIcecream(ModIntegration.croptopiaLoc("pecan_ice_cream"));
        this.addIcecream(ModIntegration.croptopiaLoc("chocolate_ice_cream"));
        this.addIcecream(ModIntegration.croptopiaLoc("vanilla_ice_cream"));
        this.addIcecream(ModIntegration.croptopiaLoc("strawberry_ice_cream"));
        this.addIcecream(ModIntegration.croptopiaLoc("kiwi_sorbet"));
        this.addSoup(ModIntegration.croptopiaLoc("potato_soup"));
        this.addSoup(ModIntegration.croptopiaLoc("leek_soup"));
        this.addSoup(ModIntegration.croptopiaLoc("pumpkin_soup"));
        this.addSoup(ModIntegration.croptopiaLoc("beef_stew"));
        this.addSoup(ModIntegration.croptopiaLoc("nether_wart_stew"));
        this.addSpecialCake(ModIntegration.croptopiaLoc("tres_leche_cake"));
        this.addSpecialCake(ModIntegration.croptopiaLoc("fruit_cake"));
        this.addVeggie(ModIntegration.croptopiaLoc("cucumber"));
        this.addVeggie(ModIntegration.croptopiaLoc("bellpepper"));
        this.addVeggie(ModIntegration.croptopiaLoc("spaghetti_squash"));
        this.addVeggie(ModIntegration.croptopiaLoc("onion"));
        this.addVeggie(ModIntegration.croptopiaLoc("baked_yam"));
        this.addVeggie(ModIntegration.croptopiaLoc("roasted_squash"));
        this.addVeggie(ModIntegration.croptopiaLoc("sweetpotato"));
        this.addVeggie(ModIntegration.croptopiaLoc("squash"));
        this.addVeggie(ModIntegration.croptopiaLoc("soybean"));
        this.addVeggie(ModIntegration.croptopiaLoc("olive"));
        this.addVeggie(ModIntegration.croptopiaLoc("coconut"));
        this.addVeggie(ModIntegration.croptopiaLoc("eggplant"));
        this.addVeggie(ModIntegration.croptopiaLoc("avocado"));
        this.addVeggie(ModIntegration.croptopiaLoc("tomato"));
        this.addVeggie(ModIntegration.croptopiaLoc("grilled_eggplant"));
        this.addVeggie(ModIntegration.croptopiaLoc("broccoli"));
        this.add(ModIntegration.croptopiaLoc("fruit_salad"), 6, 1.8f, 0, 0, 0.0f);
        this.addMeal(ModIntegration.croptopiaLoc("shepherds_pie"));
        this.addMeal(ModIntegration.croptopiaLoc("ratatouille"));
        this.addMeal(ModIntegration.croptopiaLoc("lemon_coconut_bar"));
        this.addMeal(ModIntegration.croptopiaLoc("beef_stir_fry"));
        this.addMeal(ModIntegration.croptopiaLoc("eggplant_parmesan"));
        this.addMeal(ModIntegration.croptopiaLoc("cheese_cake"));
        this.addMeal(ModIntegration.croptopiaLoc("supreme_pizza"));
        this.addMeal(ModIntegration.croptopiaLoc("rhubarb_crisp"));
        this.addMeal(ModIntegration.croptopiaLoc("ajvar"));
        this.addMeal(ModIntegration.croptopiaLoc("chicken_and_dumplings"));
        this.addMeal(ModIntegration.croptopiaLoc("anchovy_pizza"));
        this.addMeal(ModIntegration.croptopiaLoc("sticky_toffee_pudding"));
        this.addMeal(ModIntegration.croptopiaLoc("banana_nut_bread"));
        this.addMeal(ModIntegration.croptopiaLoc("figgy_pudding"));
        this.addMeal(ModIntegration.croptopiaLoc("pineapple_pepperoni_pizza"));
        this.addMeal(ModIntegration.croptopiaLoc("cucumber_salad"));
        this.addMeal(ModIntegration.croptopiaLoc("cheese_pizza"));
        this.addMeal(ModIntegration.croptopiaLoc("veggie_salad"));
        this.addMeal(ModIntegration.croptopiaLoc("steamed_broccoli"));
        this.addMeal(ModIntegration.croptopiaLoc("yoghurt"));
        this.addMeal(ModIntegration.croptopiaLoc("roasted_radishes"));
        this.addMeal(ModIntegration.croptopiaLoc("pizza"));
        this.addMeal(ModIntegration.croptopiaLoc("tofu"));
        this.addMeal(ModIntegration.croptopiaLoc("treacle_tart"));
        this.addMeal(ModIntegration.croptopiaLoc("salsa"));
        this.addMeal(ModIntegration.croptopiaLoc("trifle"));
        this.addMeal(ModIntegration.croptopiaLoc("tofu_and_dumplings"));
        this.addDrink(ModIntegration.fdLoc("hot_cocoa"));
        this.addDrink(ModIntegration.fdLoc("melon_juice"));
        this.addDrink(ModIntegration.fdLoc("milk_bottle"));
        this.addDrink(ModIntegration.fdLoc("apple_cider"));
        this.addVeggie(ModIntegration.fdLoc("mixed_salad"));
        this.addVeggie(ModIntegration.fdLoc("cabbage"));
        this.addVeggie(ModIntegration.fdLoc("onion"));
        this.addVeggie(ModIntegration.fdLoc("wild_beetroots"));
        this.addVeggie(ModIntegration.fdLoc("tomato_sauce"));
        this.addVeggie(ModIntegration.fdLoc("wild_cabbages"));
        this.addVeggie(ModIntegration.fdLoc("wild_potatoes"));
        this.addVeggie(ModIntegration.fdLoc("wild_onions"));
        this.addVeggie(ModIntegration.fdLoc("cabbage_leaf"));
        this.addVeggie(ModIntegration.fdLoc("wild_carrots"));
        this.addVeggie(ModIntegration.fdLoc("pumpkin_slice"));
        this.addVeggie(ModIntegration.fdLoc("wild_tomatoes"));
        this.addVeggie(ModIntegration.fdLoc("tomato"));
        this.addPie(ModIntegration.fdLoc("apple_pie_slice"));
        this.addPie(ModIntegration.fdLoc("sweet_berry_cheesecake_slice"));
        this.addPie(ModIntegration.fdLoc("chocolate_pie_slice"));
        this.addPie(ModIntegration.fdLoc("cake_slice"));
        this.addIcecream(ModIntegration.fdLoc("melon_popsicle"));
        this.addSoup(ModIntegration.fdLoc("noodle_soup"));
        this.addSoup(ModIntegration.fdLoc("baked_cod_stew"));
        this.addSoup(ModIntegration.fdLoc("fish_stew"));
        this.addSoup(ModIntegration.fdLoc("vegetable_soup"));
        this.addSoup(ModIntegration.fdLoc("pumpkin_soup"));
        this.addSoup(ModIntegration.fdLoc("chicken_soup"));
        this.addSoup(ModIntegration.fdLoc("beef_stew"));
        this.addMeal(ModIntegration.fdLoc("cabbage_rolls"));
        this.addMeal(ModIntegration.fdLoc("dumplings"));
        this.addMeal(ModIntegration.fdLoc("shepherds_pie"));
        this.addMeal(ModIntegration.fdLoc("steak_and_potatoes"));
        this.add(ModIntegration.fdLoc("fruit_salad"), 12, 1.8f, 0, 0, 0.0f);
        this.add(ModIntegration.fdLoc("stuffed_pumpkin"), 8, 0.6f, 0, 0, 0.0f);
        this.add(ModIntegration.fdLoc("stuffed_potato"), 8, 0.9f, 0, 0, 0.0f);
        this.addDrink(ModIntegration.xercaLoc("item_glass_of_milk"));
        this.addDrink(ModIntegration.xercaLoc("soda"));
        this.addDrink(ModIntegration.xercaLoc("item_ice_tea"));
        this.addDrink(ModIntegration.xercaLoc("item_tomato_juice"));
        this.addDrink(ModIntegration.xercaLoc("item_carrot_juice"));
        this.addDrink(ModIntegration.xercaLoc("item_wheat_juice"));
        this.addDrink(ModIntegration.xercaLoc("sweet_berry_juice"));
        this.addDrink(ModIntegration.xercaLoc("item_apple_juice"));
        this.addDrink(ModIntegration.xercaLoc("item_melon_juice"));
        this.addDrink(ModIntegration.xercaLoc("item_pumpkin_juice"));
        this.addDrink(ModIntegration.xercaLoc("cola"));
        this.addDrink(ModIntegration.xercaLoc("sake"));
        this.addDrink(ModIntegration.xercaLoc("item_full_teacup_0"));
        this.addDrink(ModIntegration.xercaLoc("item_full_teacup_6"));
        this.addDrink(ModIntegration.xercaLoc("item_full_teacup_5"));
        this.addDrink(ModIntegration.xercaLoc("item_full_teacup_4"));
        this.addDrink(ModIntegration.xercaLoc("item_full_teacup_3"));
        this.addDrink(ModIntegration.xercaLoc("item_full_teacup_2"));
        this.addDrink(ModIntegration.xercaLoc("item_full_teacup_1"));
        this.addDrink(ModIntegration.xercaLoc("carbonated_water"));
        this.add(ModIntegration.xercaLoc("item_glass_of_water"), 1, 0.0f, 45, 200, 0.2f);
        this.addMeal(ModIntegration.xercaLoc("item_shish_kebab"));
        this.addMeal(ModIntegration.xercaLoc("raw_shish_kebab"));
        this.addMeal(ModIntegration.xercaLoc("item_chubby_doner"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_meat_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_chicken"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_meat_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_chicken_chicken"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_fish_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_chicken_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_fish_meat"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_fish_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_fish_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_meat_meat"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_fish_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_pepperoni_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_meat_meat_meat"));
        this.addVeggie(ModIntegration.xercaLoc("pizza"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_mushroom_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_meat_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_meat_meat"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_fish_fish"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_mushroom_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_meat_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_meat_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_mushroom_mushroom_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_pepperoni_pepperoni_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_meat_meat_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_mushroom_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_meat_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_mushroom_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_fish_meat"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_meat_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_meat"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_fish_meat"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_fish_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("item_alexander"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_meat_mushroom_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_meat_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_mushroom_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_meat_pepperoni_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_meat_meat"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_meat_meat"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_chicken"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_mushroom_mushroom_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_mushroom_mushroom_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_chicken_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_mushroom_mushroom_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_fish_fish"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_meat_meat_meat"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_mushroom_pepperoni_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_fish"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_meat"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_mushroom_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_chicken_fish"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_meat_meat_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_mushroom_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_mushroom_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_meat"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_pepperoni_pepperoni_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_fish"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_meat_pepperoni_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_fish_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_fish_meat"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_meat_meat"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_chicken_meat"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_meat_mushroom_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_fish_fish"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_fish"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_meat_meat"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_meat_meat_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_fish_fish"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_mushroom_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_meat"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_meat_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_meat_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_meat_meat_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_meat_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_chicken_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_chicken_fish"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_mushroom_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_pepperoni_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_meat_mushroom_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_meat"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_pepperoni_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_fish_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_fish_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_fish_mushroom"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_mushroom_pepperoni_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_fish"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_chicken_chicken"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_pepperoni_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_fish_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_mushroom_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_pepperoni_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_mushroom_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_chicken_meat"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_pepperoni_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_chicken_meat_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("raw_pizza_chicken_chicken_pepperoni"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_meat"));
        this.addVeggie(ModIntegration.xercaLoc("pizza_meat_mushroom_pepperoni"));
        this.addCake(ModIntegration.xercaLoc("item_apple_cupcake"));
        this.addCake(ModIntegration.xercaLoc("sweet_berry_cupcake_fancy"));
        this.addCake(ModIntegration.xercaLoc("item_fancy_apple_cupcake"));
        this.addCake(ModIntegration.xercaLoc("glowberry_cupcake"));
        this.addCake(ModIntegration.xercaLoc("item_cocoa_cupcake"));
        this.addCake(ModIntegration.xercaLoc("item_golden_cupcake"));
        this.addCake(ModIntegration.xercaLoc("item_melon_cupcake"));
        this.addCake(ModIntegration.xercaLoc("item_honey_cupcake"));
        this.addCake(ModIntegration.xercaLoc("sweet_berry_cupcake"));
        this.addCake(ModIntegration.xercaLoc("item_carrot_cupcake"));
        this.addCake(ModIntegration.xercaLoc("item_pumpkin_cupcake"));
        this.addVeggie(ModIntegration.xercaLoc("item_tomato_slices"));
        this.addVeggie(ModIntegration.xercaLoc("item_potato_slices"));
        this.addVeggie(ModIntegration.xercaLoc("item_potato_fries"));
        this.add(ModIntegration.xercaLoc("rice_pudding"), 4, 0.6f, 0, 0, 0.0f);
        this.add(ModIntegration.xercaLoc("baked_rice_pudding"), 3, 0.2f, 0, 0, 0.0f);
        this.add(ModIntegration.xercaLoc("item_yoghurt"), 4, 0.6f, 0, 0, 0.0f);
        this.add(ModIntegration.xercaLoc("item_honeyberry_yoghurt"), 8, 2.6f, 0, 0, 0.0f);
        this.addSoup(ModIntegration.morecraftLoc("dragon_stew"));
        this.addSoup(ModIntegration.morecraftLoc("beef_stew"));
        this.addSoup(ModIntegration.morecraftLoc("pork_stew"));
        this.addSoup(ModIntegration.morecraftLoc("mutton_stew"));
        this.addSoup(ModIntegration.morecraftLoc("chevon_stew"));
        this.addSoup(ModIntegration.morecraftLoc("chicken_stew"));
        this.addSoup(ModIntegration.morecraftLoc("fish_stew"));
        this.addSoup(ModIntegration.morecraftLoc("spider_stew"));
        this.add(ModIntegration.morecraftLoc("nether_apple"), 1, 0.0f, 45, 200, 0.2f);
        this.addCake(ModIntegration.morecraftLoc("cake_slice"));
        this.addPie(ModIntegration.morecraftLoc("sweetberry_pie"));
        this.addPie(ModIntegration.morecraftLoc("nether_apple_pie"));
        this.addPie(ModIntegration.morecraftLoc("apple_pie"));
        this.addFruit(ModIntegration.ecoLoc("cooked_prickly_pear"));
        this.addFruit(ModIntegration.ecoLoc("prickly_pear"));
        this.addSoup(ModIntegration.ecoLoc("tropical_stew"));
        this.addBerries(ModIntegration.arsLoc("source_berry"));
        this.addBerries(ModIntegration.arsLoc("source_berry_roll"));
        this.add(ModIntegration.arsLoc("source_berry_pie"), 6, 0.9f, 0, 0, 0.0f);
        this.addVeggie(ModIntegration.sproutLoc("peanut_butter"));
        this.addJam(ModIntegration.sproutLoc("sweet_berry_jam"));
        this.addPie(ModIntegration.sproutLoc("pbj"));
        this.addVeggie(ModIntegration.sproutLoc("peanut_butter_cookie"));
        this.addPie(ModIntegration.sproutLoc("glow_berry_pie"));
        this.addPie(ModIntegration.sproutLoc("sweet_berry_pie"));
        this.addVeggie(ModIntegration.sproutLoc("water_sausage"));
        this.addPie(ModIntegration.sproutLoc("apple_pie"));
        this.addFruit(ModIntegration.sproutLoc("candy_apple"));
        this.add(ModIntegration.sproutLoc("golden_candy_apple"), 6, 1.2f, 0, 0, 0.0f);
        this.addCake(ModIntegration.ccLoc("oreo"));
        this.addVeggie(ModIntegration.ccLoc("cassava_root"));
        this.addDrink(ModIntegration.ccLoc("aloe_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("apple_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("apricot_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("avocado_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("banana_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("blackberry_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("blueberry_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("cherry_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("citron_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("coconut_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("dragonfruit_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("fig_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("grape_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("grapefruit_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("kiwi_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("lavender_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("lemmon_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("lime_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("mandarin_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("mango_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("oreo_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("orange_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("peach_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("persimmon_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("pineapple_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("plum_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("pomello_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("pumpkin_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("raspberry_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("redlove_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("strawberry_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("sweetberry_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("vanilla_milk_tea"));
        this.addDrink(ModIntegration.ccLoc("watermelon_milk_tea"));
        this.addSpecialCake(ModIntegration.ftLoc("grapefruit_panna_cotta"));
        this.addSpecialCake(ModIntegration.ftLoc("donauwelle"));
        this.add(ModIntegration.ftLoc("honey_pomelo_tea"), 6, 0.9f, 0, 0, 0.0f);
        this.add(ModIntegration.ftLoc("rice_with_fruits"), 6, 0.9f, 0, 0, 0.0f);
        this.addMeal(ModIntegration.ftLoc("lemon_roast_chicken"));
    }

    protected void add(ResourceLocation loc, int amount, float saturation, int potency, int duration, float chance) {
        this.DRINKABLE_ITEMS.put(loc, new DrinkableItem(loc, amount, saturation, potency, duration, chance));
    }

    protected void addDrink(ResourceLocation loc) {
        this.add(loc, 3, 0.7f, 0, 0, 0.0f);
    }

    protected void addBerries(ResourceLocation loc) {
        this.add(loc, 2, 0.3f, 0, 0, 0.0f);
    }

    protected void addJam(ResourceLocation loc) {
        this.add(loc, 2, 0.6f, 0, 0, 0.0f);
    }

    protected void addPie(ResourceLocation loc) {
        this.add(loc, 3, 1.2f, 0, 0, 0.0f);
    }

    protected void addShake(ResourceLocation loc) {
        this.add(loc, 5, 1.2f, 0, 0, 0.0f);
    }

    protected void addFruit(ResourceLocation loc) {
        this.add(loc, 2, 0.6f, 0, 0, 0.0f);
    }

    protected void addIcecream(ResourceLocation loc) {
        this.add(loc, 5, 1.0f, 0, 0, 0.0f);
    }

    protected void addSoup(ResourceLocation loc) {
        this.add(loc, 3, 0.7f, 0, 0, 0.0f);
    }

    protected void addSpecialCake(ResourceLocation loc) {
        this.add(loc, 5, 1.3f, 0, 0, 0.0f);
    }

    protected void addVeggie(ResourceLocation loc) {
        this.add(loc, 1, 0.1f, 0, 0, 0.0f);
    }

    protected void addMeal(ResourceLocation loc) {
        this.add(loc, 2, 0.6f, 0, 0, 0.0f);
    }

    protected void addCake(ResourceLocation loc) {
        this.add(loc, 2, 0.2f, 0, 0, 0.0f);
    }

    public String m_6055_() {
        return "Homeostatic - Drinkable Items";
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) throws IllegalStateException {
        ArrayList<CompletableFuture> recipeList = new ArrayList<CompletableFuture>();
        this.addDrinkableItems();
        for (Map.Entry<ResourceLocation, DrinkableItem> entry : this.DRINKABLE_ITEMS.entrySet()) {
            PackOutput.PathProvider pathProvider = this.getPath(entry.getKey());
            recipeList.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)DrinkableItemManager.parseDrinkableItem(entry.getValue()), (Path)pathProvider.m_245731_(entry.getKey())));
        }
        return CompletableFuture.allOf((CompletableFuture[])recipeList.toArray(CompletableFuture[]::new));
    }

    private PackOutput.PathProvider getPath(ResourceLocation loc) {
        return this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "environment/drinkable/");
    }
}

