/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import com.google.gson.JsonElement;
import homeostatic.common.block.BlockRadiation;
import homeostatic.common.block.BlockRadiationManager;
import homeostatic.data.integration.ModIntegration;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RadiationBlocksProvider
implements DataProvider {
    private final Map<ResourceLocation, BlockRadiation> RADIATION_MAP = new HashMap<ResourceLocation, BlockRadiation>();
    private final PackOutput packOutput;

    public RadiationBlocksProvider(@NotNull PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    protected void registerRadiationBlocks() {
        this.add(ModIntegration.mcLoc("soul_campfire"), 8325.0);
        this.add(ModIntegration.mcLoc("campfire"), 5550.0);
        this.add(ModIntegration.mcLoc("soul_fire"), 1950.0);
        this.add(ModIntegration.mcLoc("blast_furnace"), 1800.0);
        this.add(ModIntegration.mcLoc("lava"), 1550.0);
        this.add(ModIntegration.mcLoc("fire"), 1300.0);
        this.add(ModIntegration.mcLoc("furnace"), 1300.0);
        this.add(ModIntegration.mcLoc("magma_block"), 1200.0);
        this.add(ModIntegration.mcLoc("smoker"), 1100.0);
        this.add(ModIntegration.mcLoc("soul_torch"), 525.0);
        this.add(ModIntegration.mcLoc("soul_wall_torch"), 525.0);
        this.add(ModIntegration.mcLoc("soul_lantern"), 525.0);
        this.add(ModIntegration.mcLoc("nether_portal"), 350.0);
        this.add(ModIntegration.mcLoc("torch"), 350.0);
        this.add(ModIntegration.mcLoc("wall_torch"), 350.0);
        this.add(ModIntegration.mcLoc("lantern"), 350.0);
        this.add(ModIntegration.bygLoc("cryptic_campfire"), 7250.0);
        this.add(ModIntegration.bygLoc("boric_campfire"), 6250.0);
        this.add(ModIntegration.bygLoc("cryptic_magma_block"), 1200.0);
        this.add(ModIntegration.bygLoc("boric_lantern"), 400.0);
        this.add(ModIntegration.bygLoc("cryptic_lantern"), 470.0);
    }

    protected void add(ResourceLocation loc, double maxRadiation) {
        this.RADIATION_MAP.put(loc, new BlockRadiation(loc, maxRadiation));
    }

    public String m_6055_() {
        return "Homeostatic - Block Radiation ";
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) throws IllegalStateException {
        ArrayList<CompletableFuture> recipeList = new ArrayList<CompletableFuture>();
        this.registerRadiationBlocks();
        for (Map.Entry<ResourceLocation, BlockRadiation> entry : this.RADIATION_MAP.entrySet()) {
            PackOutput.PathProvider pathProvider = this.getPath(entry.getKey());
            recipeList.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)BlockRadiationManager.parseBlockRadiation(entry.getValue()), (Path)pathProvider.m_245731_(entry.getKey())));
        }
        return CompletableFuture.allOf((CompletableFuture[])recipeList.toArray(CompletableFuture[]::new));
    }

    private PackOutput.PathProvider getPath(ResourceLocation loc) {
        return this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "environment/block_radiation/");
    }
}

