/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data.recipe;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import homeostatic.Homeostatic;
import homeostatic.mixin.RecipeProviderAccessor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeProviderBase
implements DataProvider {
    private final PackOutput packOutput;

    protected RecipeProviderBase(@NotNull PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) throws IllegalStateException {
        PackOutput.PathProvider pathProvider = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "recipes");
        PackOutput.PathProvider advancementPathProvider = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "advancements");
        HashSet resourceLocationSet = Sets.newHashSet();
        ArrayList recipeList = new ArrayList();
        this.registerRecipes(recipe -> {
            CompletableFuture<?> recipeAdvancement;
            if (!resourceLocationSet.add(recipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.m_6445_());
            }
            recipeList.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)recipe.m_125966_(), (Path)pathProvider.m_245731_(recipe.m_6445_())));
            JsonObject advancement = recipe.m_5860_();
            if (advancement != null && (recipeAdvancement = this.saveAdvancement(cache, (FinishedRecipe)recipe, advancement, advancementPathProvider)) != null) {
                recipeList.add(recipeAdvancement);
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])recipeList.toArray(CompletableFuture[]::new));
    }

    protected abstract void registerRecipes(Consumer<FinishedRecipe> var1);

    @Nullable
    protected CompletableFuture<?> saveAdvancement(CachedOutput cache, FinishedRecipe recipe, JsonObject json, PackOutput.PathProvider path) {
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path.m_245731_(recipe.m_6448_()));
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromItem(ItemLike item) {
        return RecipeProviderAccessor.homeostatic_condition(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromTag(TagKey<Item> key) {
        return RecipeProviderAccessor.homeostatic_condition(ItemPredicate.Builder.m_45068_().m_204145_(key).m_45077_());
    }

    protected static void specialRecipe(Consumer<FinishedRecipe> consumer, SimpleCraftingRecipeSerializer<?> serializer) {
        ResourceLocation name = BuiltInRegistries.f_256769_.m_7981_(serializer);
        SpecialRecipeBuilder.m_245676_(serializer).m_126359_(consumer, Homeostatic.loc("dynamic/" + Objects.requireNonNull(name).m_135815_()).toString());
    }

    protected static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> pTag) {
        return RecipeProviderBase.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(pTag).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance has(ItemLike pItemLike) {
        return RecipeProviderBase.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{pItemLike}).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, predicates);
    }
}

