/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.integrations.jei;

import homeostatic.Homeostatic;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.recipe.ArmorEnhancement;
import homeostatic.common.recipe.HelmetThermometer;
import homeostatic.config.ConfigHandler;
import homeostatic.integrations.jei.ArmorEnhancementRecipeMaker;
import homeostatic.integrations.jei.HelmetThermometerRecipeMaker;
import homeostatic.util.WaterHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return Homeostatic.loc("jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Minecraft minecraft = Minecraft.m_91087_();
        RecipeManager recipeManager = Objects.requireNonNull(minecraft.f_91073_).m_7465_();
        List allCraftingRecipes = recipeManager.m_44013_(RecipeType.f_44107_);
        List<CraftingRecipe> armorEnhancementRecipes = JEIPlugin.addArmorCraftingRecipes(allCraftingRecipes);
        registration.addRecipes(RecipeTypes.CRAFTING, armorEnhancementRecipes);
        registration.addRecipes(RecipeTypes.CRAFTING, JEIPlugin.getFilterCraftingRecipes());
        if (!ConfigHandler.Common.requireThermometer()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)HomeostaticItems.THERMOMETER)));
        }
    }

    private static List<CraftingRecipe> addArmorCraftingRecipes(List<CraftingRecipe> allCraftingRecipes) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(ArmorEnhancement.class, ArmorEnhancementRecipeMaker::createRecipes);
        if (ConfigHandler.Common.requireThermometer()) {
            replacers.put(HelmetThermometer.class, HelmetThermometerRecipeMaker::createRecipes);
        }
        return allCraftingRecipes.stream().map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                List results = (List)supplier.get();
                return results.stream();
            }
            catch (RuntimeException e) {
                Homeostatic.LOGGER.error("Failed to create JEI Recipes for %s %s", recipeClass, (Object)e);
                return Stream.of(new CraftingRecipe[0]);
            }
        }).toList();
    }

    private static List<CraftingRecipe> getFilterCraftingRecipes() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{HomeostaticItems.WATER_FILTER});
        ItemStack leatherFlaskBase = new ItemStack((ItemLike)HomeostaticItems.LEATHER_FLASK);
        ItemStack leatherFlask = WaterHelper.getFilledItem(leatherFlaskBase, (Fluid)HomeostaticFluids.PURIFIED_WATER, 5000);
        String group = "jei.flask.filter";
        Ingredient baseFlaskIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{leatherFlaskBase.m_41720_()});
        NonNullList recipeInputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseFlaskIngredient, ingredient});
        recipes.add((CraftingRecipe)new ShapelessRecipe(new ResourceLocation("homeostatic", group + ".purified_leather_flask"), group, CraftingBookCategory.MISC, leatherFlask, recipeInputs));
        return recipes;
    }
}

