/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.temperature.ThermometerInfo;
import homeostatic.network.IData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ThermometerData
implements IData {
    boolean hasThermometer;

    public ThermometerData(ThermometerInfo info) {
        this.hasThermometer = info.hasThermometer();
    }

    public ThermometerData(FriendlyByteBuf buf) {
        this.hasThermometer = buf.readBoolean();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.hasThermometer);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> Minecraft.m_91087_().f_91074_.getCapability(CapabilityRegistry.THERMOMETER_CAPABILITY).ifPresent(data -> data.setHasThermometer(this.hasThermometer)));
        }
    }
}

