/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.network;

import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.water.WaterInfo;
import homeostatic.network.IData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class WaterData
implements IData {
    int waterLevel;
    float waterSaturationLevel;
    float waterExhaustionLevel;

    public WaterData(WaterInfo waterInfo) {
        this.waterLevel = waterInfo.getWaterLevel();
        this.waterSaturationLevel = waterInfo.getWaterSaturationLevel();
        this.waterExhaustionLevel = waterInfo.getWaterExhaustionLevel();
    }

    public WaterData(FriendlyByteBuf buf) {
        this.waterLevel = buf.readInt();
        this.waterSaturationLevel = buf.readFloat();
        this.waterExhaustionLevel = buf.readFloat();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.waterLevel);
        buf.writeFloat(this.waterSaturationLevel);
        buf.writeFloat(this.waterExhaustionLevel);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> Minecraft.m_91087_().f_91074_.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> {
                data.setWaterLevel(this.waterLevel);
                data.setWaterSaturationLevel(this.waterSaturationLevel);
                data.setWaterExhaustionLevel(this.waterExhaustionLevel);
            }));
        }
    }
}

