/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.Homeostatic;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.overlay.Overlay;
import homeostatic.util.WaterHelper;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="homeostatic")
public class WaterHud
extends Overlay {
    protected static int tickCount = 0;
    public static final ResourceLocation WATER_BAR = Homeostatic.loc("textures/gui/icons.png");
    public static final int BAR_WIDTH = 9;
    public static final int BAR_HEIGHT = 9;

    @Override
    public void render(PoseStack matrix, Minecraft mc, @Nullable BlockPos pos, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Gui gui = mc.f_91065_;
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)WATER_BAR);
        MobEffectInstance effectInstance = mc.f_91074_.m_21124_(HomeostaticEffects.THIRST);
        player.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> {
            int waterLevel = data.getWaterLevel();
            float waterSaturationLevel = data.getWaterSaturationLevel();
            WaterHelper.drawWaterBar(scaledWidth, scaledHeight, effectInstance, gui, matrix, waterSaturationLevel, waterLevel, tickCount);
        });
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ++tickCount;
        tickCount %= 1200;
    }
}

