/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.proxy;

import biomesoplenty.api.biome.BOPBiomes;
import homeostatic.Homeostatic;
import homeostatic.common.biome.BiomeRegistry;
import homeostatic.common.block.HomeostaticBlocks;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.common.item.HomeostaticItems;
import homeostatic.common.recipe.HomeostaticRecipes;
import homeostatic.config.ConfigHandler;
import homeostatic.network.NetworkHandler;
import homeostatic.util.RegistryHelper;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import potionstudios.byg.common.world.biome.BYGBiomes;
import potionstudios.byg.reg.RegistryObject;

@Mod.EventBusSubscriber(modid="homeostatic")
public class CommonProxy {
    public void start() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ConfigHandler.init();
        this.registerListeners(bus);
        BiomeRegistry.init();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::serverStart);
    }

    public void registerListeners(IEventBus bus) {
        bus.register(RegistryListener.class);
    }

    public void serverStart(ServerStartedEvent event) {
        if (ModList.get().isLoaded("biomesoplenty")) {
            for (ResourceKey biomeResourceKey : BOPBiomes.getAllBiomes()) {
                this.logBiomeInfo(event.getServer(), (ResourceKey<Biome>)biomeResourceKey);
            }
        }
        if (ModList.get().isLoaded("byg")) {
            for (RegistryObject biomeRegistryObject : BYGBiomes.BIOMES_BY_TAG.values()) {
                ResourceKey biomeResourceKey = biomeRegistryObject.getResourceKey();
                this.logBiomeInfo(event.getServer(), (ResourceKey<Biome>)biomeResourceKey);
            }
        }
    }

    private void logBiomeInfo(MinecraftServer server, ResourceKey<Biome> biomeResourceKey) {
        Registry biomeRegistry = RegistryHelper.getRegistry(server, Registries.f_256952_);
        String biomeName = biomeResourceKey.m_135782_().toString();
        Biome biome = (Biome)biomeRegistry.m_6246_(biomeResourceKey);
        BiomeRegistry.BiomeCategory biomeCategory = BiomeRegistry.getBiomeCategory((Holder<Biome>)biomeRegistry.m_246971_(biomeResourceKey));
        Homeostatic.LOGGER.debug("Biome: " + biomeName + "\npreciptitation=" + biome.m_47530_() + "\ntemperature=" + biome.m_47554_() + "\ndownfall=" + biome.m_47548_() + "\nbiomeCategory=" + biomeCategory);
    }

    public static final class RegistryListener {
        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            NetworkHandler.init();
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerEvent(RegisterEvent event) {
            event.register(Registries.f_256929_, HomeostaticEffects::init);
            event.register(Registries.f_256913_, HomeostaticItems::init);
            event.register(Registries.f_256747_, HomeostaticBlocks::init);
            event.register(Registries.f_256808_, HomeostaticFluids::init);
            event.register(((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getRegistryKey(), HomeostaticFluids::initTypes);
            event.register(Registries.f_256764_, HomeostaticRecipes::init);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerCreativeTab(CreativeModeTabEvent.Register event) {
            event.registerCreativeModeTab(new ResourceLocation("homeostatic", "items"), builder -> builder.m_257737_(() -> new ItemStack((ItemLike)HomeostaticItems.PURIFIED_WATER_BUCKET)).m_257941_((Component)Component.m_237115_((String)"homeostatic.items")).m_257501_((features, output, tab) -> {
                for (Map.Entry<ResourceLocation, Item> entry : HomeostaticItems.getAll().entrySet()) {
                    Item item = entry.getValue();
                    output.m_246342_(new ItemStack((ItemLike)item));
                }
            }));
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerCreativeTab(CreativeModeTabEvent.BuildContents event) {
            if (event.getTab() == CreativeModeTabs.f_256869_) {
                for (Map.Entry<ResourceLocation, Item> entry : HomeostaticItems.getAll().entrySet()) {
                    Item item = entry.getValue();
                    event.m_246342_(new ItemStack((ItemLike)item));
                }
            }
        }
    }
}

