/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.capabilities;

import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.temperature.BodyTemperature;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class Temperature {
    private float skinTemperature = 1.6344578f;
    private float lastSkinTemperature = 1.6344578f;
    private float coreTemperature = 1.6344578f;
    private float localTemperature = 0.0f;

    public static Tag writeNBT(Capability<Temperature> capability, Temperature instance, Direction side) {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("skinTemperature", instance.getSkinTemperature());
        tag.m_128350_("lastSkinTemperature", instance.getLastSkinTemperature());
        tag.m_128350_("coreTemperature", instance.getCoreTemperature());
        tag.m_128350_("localTemperature", instance.getLocalTemperature());
        return tag;
    }

    public static void readNBT(Capability<Temperature> capability, Temperature instance, Direction side, Tag nbt) {
        instance.setSkinTemperature(((CompoundTag)nbt).m_128457_("skinTemperature"));
        instance.setLastSkinTemperature(((CompoundTag)nbt).m_128457_("lastSkinTemperature"));
        instance.setCoreTemperature(((CompoundTag)nbt).m_128457_("coreTemperature"));
        instance.setLocalTemperature(((CompoundTag)nbt).m_128457_("localTemperature"));
    }

    public void setSkinTemperature(float skinTemperature) {
        this.skinTemperature = skinTemperature;
    }

    public void setLastSkinTemperature(float lastSkinTemperature) {
        this.lastSkinTemperature = lastSkinTemperature;
    }

    public void setCoreTemperature(float coreTemperature) {
        this.coreTemperature = coreTemperature;
    }

    public void setLocalTemperature(float temperature) {
        this.localTemperature = temperature;
    }

    public void setTemperatureData(float localTemperature, BodyTemperature bodyTemperature) {
        this.setSkinTemperature(bodyTemperature.getSkinTemperature());
        this.setLastSkinTemperature(bodyTemperature.getLastSkinTemperature());
        this.setCoreTemperature(bodyTemperature.getCoreTemperature());
        this.setLocalTemperature(localTemperature);
    }

    public float getSkinTemperature() {
        return this.skinTemperature;
    }

    public float getLastSkinTemperature() {
        return this.lastSkinTemperature;
    }

    public float getCoreTemperature() {
        return this.coreTemperature;
    }

    public float getLocalTemperature() {
        return this.localTemperature;
    }

    public void checkTemperatureLevel(Player player) {
        float amount;
        if (this.coreTemperature < 1.5542169f) {
            player.m_146917_(player.m_146888_() + 5);
        } else if (this.coreTemperature > 1.7993976f) {
            amount = (1.0f + (this.coreTemperature - 1.7993976f)) * 0.5f;
            player.m_6469_(new DamageSource("hyperthermia").m_19380_().m_19382_(), amount);
        }
        if (this.skinTemperature > 2.5572288f) {
            amount = (1.0f + (this.skinTemperature - 2.5572288f)) * 0.35f;
            player.m_6469_(new DamageSource("heat").m_19380_().m_19382_(), amount);
        }
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        @Nonnull
        private final Temperature instance = new Temperature();
        private final LazyOptional<Temperature> handler = LazyOptional.of(this::getInstance);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == null) {
                return LazyOptional.empty();
            }
            return CapabilityRegistry.TEMPERATURE_CAPABILITY.orEmpty(cap, this.handler);
        }

        public Temperature getInstance() {
            return this.instance;
        }

        public Tag serializeNBT() {
            return Temperature.writeNBT(CapabilityRegistry.TEMPERATURE_CAPABILITY, this.instance, null);
        }

        public void deserializeNBT(Tag nbt) {
            Temperature.readNBT(CapabilityRegistry.TEMPERATURE_CAPABILITY, this.instance, null, nbt);
        }
    }
}

