/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.capabilities;

import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.wetness.WetnessInfo;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class Wetness {
    private int wetnessLevel = 0;
    private float moistureLevel = 0.0f;

    public static Tag writeNBT(Capability<Wetness> capability, Wetness instance, Direction side) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("wetnessLevel", instance.getWetnessLevel());
        tag.m_128350_("moistureLevel", instance.getMoistureLevel());
        return tag;
    }

    public static void readNBT(Capability<Wetness> capability, Wetness instance, Direction side, Tag nbt) {
        instance.setWetnessLevel(((CompoundTag)nbt).m_128451_("wetnessLevel"));
        instance.setMoistureLevel(((CompoundTag)nbt).m_128457_("moistureLevel"));
    }

    public void setWetnessLevel(int wetnessLevel) {
        this.wetnessLevel = wetnessLevel;
    }

    public void setMoistureLevel(float moistureLevel) {
        this.moistureLevel = moistureLevel;
    }

    public void setWetnessData(WetnessInfo wetnessInfo) {
        this.setWetnessLevel(wetnessInfo.getWetnessLevel());
        this.setMoistureLevel(wetnessInfo.getMoistureLevel());
    }

    public int getWetnessLevel() {
        return this.wetnessLevel;
    }

    public float getMoistureLevel() {
        return this.moistureLevel;
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        @Nonnull
        private final Wetness instance = new Wetness();
        private final LazyOptional<Wetness> handler = LazyOptional.of(this::getInstance);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == null) {
                return LazyOptional.empty();
            }
            return CapabilityRegistry.WETNESS_CAPABILITY.orEmpty(cap, this.handler);
        }

        public Wetness getInstance() {
            return this.instance;
        }

        public Tag serializeNBT() {
            return Wetness.writeNBT(CapabilityRegistry.WETNESS_CAPABILITY, this.instance, null);
        }

        public void deserializeNBT(Tag nbt) {
            Wetness.readNBT(CapabilityRegistry.WETNESS_CAPABILITY, this.instance, null, nbt);
        }
    }
}

