/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.common.item;

import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.fluid.HomeostaticFluids;
import homeostatic.util.WaterHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class WaterContainerItem
extends ItemFluidContainer {
    boolean canDrink = false;

    public WaterContainerItem(Item.Properties properties, int capacity) {
        super(properties.m_41503_(capacity), capacity);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hitResult = WaterContainerItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos pos = hitResult.m_82425_();
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        if ((fluidHandlerItem.getFluidInTank(0).isEmpty() || fluidHandlerItem.getFluidInTank(0).getFluid() == Fluids.f_76193_) && level.m_6425_(pos).m_76152_() == Fluids.f_76193_) {
            return InteractionResultHolder.m_19090_((Object)this.getFilledItem(stack, player));
        }
        if (this.canDrink(stack, player)) {
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        fluidHandlerItem.drain(250, IFluidHandler.FluidAction.EXECUTE);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (fluidHandlerItem.getFluidInTank(0).isEmpty()) {
                return this.getCraftingRemainingItem(stack);
            }
            this.updateDamage(stack);
            if (!player.f_19853_.f_46443_) {
                if (fluidHandlerItem.getFluidInTank(0).getFluid() == Fluids.f_76193_) {
                    WaterHelper.drinkWater((ServerPlayer)player, true, true);
                } else if (fluidHandlerItem.getFluidInTank(0).getFluid() == HomeostaticFluids.PURIFIED_WATER) {
                    WaterHelper.drinkWater((ServerPlayer)player, false, true);
                }
            }
        }
        return stack;
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag tag) {
        return new FluidHandlerItemStack.SwapEmpty(stack, stack.getCraftingRemainingItem(), this.capacity);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        MutableComponent textComponent = Component.m_237115_((String)"tooltip.water_container.empty");
        int amount = 0;
        super.m_7373_(stack, level, components, tooltipFlag);
        if (stack.m_41737_("Fluid") != null) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
            textComponent = Component.m_237115_((String)fluidHandlerItem.getFluidInTank(0).getDisplayName().getString());
            amount = fluidHandlerItem.getFluidInTank(0).getAmount();
        }
        components.add((Component)Component.m_237115_((String)(textComponent.getString() + String.format(": %d uses.", amount / 250))).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int m_8105_(ItemStack stack) {
        return this.canDrink ? 32 : 0;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public ItemStack getFilledItem(ItemStack stack, Player player) {
        ItemStack copy = stack.m_41777_();
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        player.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        fluidHandlerItem.fill(new FluidStack((Fluid)Fluids.f_76193_, this.capacity), IFluidHandler.FluidAction.EXECUTE);
        this.updateDamage(copy);
        return copy;
    }

    public void updateDamage(ItemStack stack) {
        if (stack.m_41763_()) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
            stack.m_41721_(Math.min(stack.m_41776_(), stack.m_41776_() - fluidHandlerItem.getFluidInTank(0).getAmount()));
        }
    }

    public boolean canDrink(ItemStack stack, Player player) {
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
        this.canDrink = !fluidHandlerItem.getFluidInTank(0).isEmpty() && fluidHandlerItem.getFluidInTank(0).getAmount() >= 250;
        player.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> {
            this.canDrink = this.canDrink && data.getWaterLevel() < 20;
        });
        return this.canDrink;
    }
}

