/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.config;

import homeostatic.util.ColorHelper;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="homeostatic", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ConfigHandler {
    private ConfigHandler() {
    }

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Client.CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Server.CONFIG_SPEC);
    }

    public static final class Client {
        public static final ForgeConfigSpec CONFIG_SPEC;
        private static final Client CONFIG;
        private static final List<String> positions;
        private static Color temperatureColorCold;
        private static Color temperatureColorHot;
        private static final Predicate<Object> hexRangeValidator;
        public final ForgeConfigSpec.BooleanValue debugEnabled;
        public final ForgeConfigSpec.BooleanValue useFahrenheit;
        public final ForgeConfigSpec.ConfigValue<String> position;
        public final ForgeConfigSpec.IntValue offsetX;
        public final ForgeConfigSpec.IntValue offsetY;
        public final ForgeConfigSpec.DoubleValue scale;
        public final ForgeConfigSpec.ConfigValue<String> temperatureColorRange;

        Client(// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull ForgeConfigSpec.Builder builder) {
            this.debugEnabled = builder.comment("Show temperature debug info.").define("debugEnabled", false);
            this.useFahrenheit = builder.comment("Use Fahrenheit, otherwise use Celcius.").define("useFahrenheit", true);
            this.position = builder.comment("Position of debug info, one of: " + positions).defineInList("position", (Object)"TOPRIGHT", positions);
            this.offsetX = builder.comment("X offset").defineInRange("offsetX", 3, -100, 100);
            this.offsetY = builder.comment("Y offset").defineInRange("offsetY", 3, -100, 100);
            this.scale = builder.comment("The size of the text info (multiplier)").defineInRange("scale", 0.5, 0.5, 2.0);
            this.temperatureColorRange = builder.comment("Temperature color range (Format (cold->hot): #3ab3da->#f9801d)").define("temperatureColorRange", (Object)"#3ab3da->#f9801d", hexRangeValidator);
        }

        public static boolean debugEnabled() {
            return (Boolean)Client.CONFIG.debugEnabled.get();
        }

        public static boolean useFahrenheit() {
            return (Boolean)Client.CONFIG.useFahrenheit.get();
        }

        public static String position() {
            return (String)Client.CONFIG.position.get();
        }

        public static int offsetX() {
            return (Integer)Client.CONFIG.offsetX.get();
        }

        public static int offsetY() {
            return (Integer)Client.CONFIG.offsetY.get();
        }

        public static double scale() {
            return (Double)Client.CONFIG.scale.get();
        }

        public static Color temperatureColorCold() {
            return temperatureColorCold;
        }

        public static Color temperatureColorHot() {
            return temperatureColorHot;
        }

        public static void init() {
            String[] temperatureColors = ((String)Client.CONFIG.temperatureColorRange.get()).split("->");
            temperatureColorCold = ColorHelper.decode(temperatureColors[0]);
            temperatureColorHot = ColorHelper.decode(temperatureColors[1]);
        }

        static {
            positions = Arrays.asList("TOPLEFT", "TOPRIGHT", "BOTTOMLEFT", "BOTTOMRIGHT");
            temperatureColorCold = ColorHelper.decode("#3ab3da");
            temperatureColorHot = ColorHelper.decode("#f9801d");
            hexRangeValidator = s -> s instanceof String && ((String)s).matches("#[a-zA-Z\\d]{6}->#[a-zA-Z\\d]{6}");
            Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
            CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
            CONFIG = (Client)specPair.getLeft();
        }
    }

    public static final class Server {
        public static final ForgeConfigSpec CONFIG_SPEC;
        private static final Server CONFIG;
        private static ForgeConfigSpec.IntValue DRINK_AMOUNT;
        private static ForgeConfigSpec.DoubleValue DRINK_SATURATION;
        private static ForgeConfigSpec.IntValue EFFECT_POTENCY;
        private static ForgeConfigSpec.IntValue EFFECT_DURATION;
        private static ForgeConfigSpec.DoubleValue EFFECT_CHANCE;

        Server(ForgeConfigSpec.Builder builder) {
            DRINK_AMOUNT = builder.comment("Amount of water that can drank per interaction in half shanks. Purified water is 3X. Default 1").defineInRange("DRINK_AMOUNT", 1, 1, 20);
            DRINK_SATURATION = builder.comment("Amount of saturation gained per drink of purified water. Default 0.7").defineInRange("DRINK_SATURATION", 0.7, 0.0, 20.0);
            EFFECT_POTENCY = builder.comment("Potency of thirst effect when drinking from an open water source. Default 25").defineInRange("EFFECT_POTENCY", 45, 1, 255);
            EFFECT_DURATION = builder.comment("Duration of thirst effect in ticks (20/second). Default 200").defineInRange("EFFECT_DURATION", 200, 1, 6000);
            EFFECT_CHANCE = builder.comment("Chance to give thirst status effect. Default 0.2").defineInRange("EFFECT_CHANCE", 0.2, 0.0, 1.0);
        }

        public static int drinkAmount() {
            return (Integer)DRINK_AMOUNT.get();
        }

        public static float drinkSaturation() {
            double hydration = (Double)DRINK_SATURATION.get();
            return (float)hydration;
        }

        public static int effectPotency() {
            return (Integer)EFFECT_POTENCY.get();
        }

        public static int effectDuration() {
            return (Integer)EFFECT_DURATION.get();
        }

        public static float effectChance() {
            double chance = (Double)EFFECT_CHANCE.get();
            return (float)chance;
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
            CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
            CONFIG = (Server)specPair.getLeft();
        }
    }
}

