/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.data;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;

public class AdvancedCookingRecipeBuilder
implements RecipeBuilder {
    private final Ingredient result;
    private final Ingredient ingredient;
    private final float experience;
    private final int cookingTime;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final SimpleCookingSerializer<?> serializer;

    private AdvancedCookingRecipeBuilder(Ingredient pResult, Ingredient pIngredient, float pExperience, int pCookingTime, SimpleCookingSerializer<?> pSerializer) {
        this.result = pResult;
        this.ingredient = pIngredient;
        this.experience = pExperience;
        this.cookingTime = pCookingTime;
        this.serializer = pSerializer;
    }

    public static AdvancedCookingRecipeBuilder cooking(Ingredient pIngredient, Ingredient pResult, float pExperience, int pCookingTime, SimpleCookingSerializer<?> pSerializer) {
        return new AdvancedCookingRecipeBuilder(pResult, pIngredient, pExperience, pCookingTime, pSerializer);
    }

    public static AdvancedCookingRecipeBuilder campfireCooking(Ingredient pIngredient, Ingredient pResult, float pExperience, int pCookingTime) {
        return AdvancedCookingRecipeBuilder.cooking(pIngredient, pResult, pExperience, pCookingTime, RecipeSerializer.f_44094_);
    }

    public static AdvancedCookingRecipeBuilder blasting(Ingredient pIngredient, Ingredient pResult, float pExperience, int pCookingTime) {
        return AdvancedCookingRecipeBuilder.cooking(pIngredient, pResult, pExperience, pCookingTime, RecipeSerializer.f_44092_);
    }

    public static AdvancedCookingRecipeBuilder smelting(Ingredient pIngredient, Ingredient pResult, float pExperience, int pCookingTime) {
        return AdvancedCookingRecipeBuilder.cooking(pIngredient, pResult, pExperience, pCookingTime, RecipeSerializer.f_44091_);
    }

    public static AdvancedCookingRecipeBuilder smoking(Ingredient pIngredient, Ingredient pResult, float pExperience, int pCookingTime) {
        return AdvancedCookingRecipeBuilder.cooking(pIngredient, pResult, pExperience, pCookingTime, RecipeSerializer.f_44093_);
    }

    public AdvancedCookingRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public AdvancedCookingRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return Arrays.stream(this.result.m_43908_()).findFirst().get().m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.group == null ? "" : this.group, this.ingredient, this.result, this.experience, this.cookingTime, this.advancement, new ResourceLocation(pRecipeId.m_135827_(), "recipes/" + pRecipeId.m_135815_()), (RecipeSerializer<? extends AbstractCookingRecipe>)this.serializer));
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pId);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Ingredient result;
        private final float experience;
        private final int cookingTime;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<? extends AbstractCookingRecipe> serializer;

        public Result(ResourceLocation pId, String pGroup, Ingredient pIngredient, Ingredient pResult, float pExperience, int pCookingTime, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId, RecipeSerializer<? extends AbstractCookingRecipe> pSerializer) {
            this.id = pId;
            this.group = pGroup;
            this.ingredient = pIngredient;
            this.result = pResult;
            this.experience = pExperience;
            this.cookingTime = pCookingTime;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
            this.serializer = pSerializer;
        }

        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            pJson.add("ingredient", this.ingredient.m_43942_());
            pJson.add("result", this.result.m_43942_());
            pJson.addProperty("experience", (Number)Float.valueOf(this.experience));
            pJson.addProperty("cookingtime", (Number)this.cookingTime);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

