/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.event;

import homeostatic.config.ConfigHandler;
import homeostatic.overlay.OverlayManager;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="homeostatic", value={Dist.CLIENT})
public class GameOverlayEventHandler {
    private final OverlayManager overlayManager = OverlayManager.INSTANCE;
    public static final GameOverlayEventHandler INSTANCE = new GameOverlayEventHandler();
    private static boolean enabled = false;
    private final IGuiOverlay OVERLAY = (gui, poseStack, partialTick, width, height) -> {
        if (enabled && ConfigHandler.Client.debugEnabled() && !Minecraft.m_91087_().f_91066_.f_92063_) {
            this.overlayManager.renderOverlay(poseStack);
        }
    };
    private final IGuiOverlay WATER_LEVEL_OVERLAY = (gui, poseStack, partialTick, width, height) -> {
        if (!Minecraft.m_91087_().f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            this.overlayManager.renderWaterOverlay(poseStack);
        }
    };
    private final IGuiOverlay TEMPERATURE_OVERLAY = (gui, poseStack, partialTick, width, height) -> {
        if (!Minecraft.m_91087_().f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            this.overlayManager.renderTemperatureOverlay(poseStack);
        }
    };

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        ConfigHandler.Client.init();
        enabled = true;
    }

    public void onModConfigReloading(ModConfigEvent.Reloading event) {
        if (enabled && event.getConfig().getSpec() == ConfigHandler.Client.CONFIG_SPEC) {
            ConfigHandler.Client.init();
        }
    }

    public void onRegisterOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("homeostatic_overlay", GameOverlayEventHandler.INSTANCE.OVERLAY);
        event.registerBelowAll("water_level", GameOverlayEventHandler.INSTANCE.WATER_LEVEL_OVERLAY);
        event.registerAboveAll("temperature", GameOverlayEventHandler.INSTANCE.TEMPERATURE_OVERLAY);
    }

    static {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(INSTANCE::onLoadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(INSTANCE::onModConfigReloading);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(INSTANCE::onRegisterOverlays);
    }
}

