/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.config.ConfigHandler;
import homeostatic.overlay.TemperatureInfo;
import homeostatic.overlay.TemperatureOverlay;
import homeostatic.overlay.WaterHud;
import homeostatic.overlay.WetnessOverlay;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;

public class OverlayManager {
    public static final OverlayManager INSTANCE = new OverlayManager();
    public final WaterHud waterHud = new WaterHud();
    public final WetnessOverlay wetnessOverlay = new WetnessOverlay();
    public final TemperatureOverlay temperatureOverlay = new TemperatureOverlay();
    public final TemperatureInfo temperatureInfo = new TemperatureInfo();

    private OverlayManager() {
    }

    public void renderOverlay(PoseStack matrix) {
        Minecraft mc = Minecraft.m_91087_();
        BlockPos pos = Objects.requireNonNull(mc.m_91288_()).m_20183_();
        if (mc.f_91073_ != null && mc.f_91073_.m_46749_(pos)) {
            float scale = (float)ConfigHandler.Client.scale();
            int scaledWidth = (int)((float)mc.m_91268_().m_85445_() / scale);
            int scaledHeight = (int)((float)mc.m_91268_().m_85446_() / scale);
            matrix.m_85836_();
            matrix.m_85841_(scale, scale, scale);
            this.temperatureInfo.renderText(matrix, mc, pos, scaledWidth, scaledHeight);
            matrix.m_85849_();
        }
    }

    public void renderWaterOverlay(PoseStack matrix) {
        Minecraft mc = Minecraft.m_91087_();
        BlockPos pos = Objects.requireNonNull(mc.m_91288_()).m_20183_();
        if (mc.f_91073_ != null && mc.f_91073_.m_46749_(pos)) {
            int scaledWidth = mc.m_91268_().m_85445_();
            int scaledHeight = mc.m_91268_().m_85446_();
            matrix.m_85836_();
            this.waterHud.render(matrix, mc, scaledWidth, scaledHeight);
            this.wetnessOverlay.render(mc, scaledWidth, scaledHeight);
            matrix.m_85849_();
        }
    }

    public void renderTemperatureOverlay(PoseStack matrix) {
        Minecraft mc = Minecraft.m_91087_();
        BlockPos pos = Objects.requireNonNull(mc.m_91288_()).m_20183_();
        if (mc.f_91073_ != null && mc.f_91073_.m_46749_(pos)) {
            int scaledWidth = mc.m_91268_().m_85445_();
            int scaledHeight = mc.m_91268_().m_85446_();
            matrix.m_85836_();
            this.temperatureOverlay.render(matrix, mc, scaledWidth, scaledHeight);
            matrix.m_85849_();
        }
    }
}

