/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import homeostatic.Homeostatic;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.effect.HomeostaticEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="homeostatic")
public class WaterHud
extends GuiComponent {
    protected static int tickCount = 0;
    public static final ResourceLocation WATER_BAR = new ResourceLocation("homeostatic", "textures/gui/icons.png");
    protected static final int BAR_WIDTH = 9;
    protected static final int BAR_HEIGHT = 9;

    public void render(PoseStack matrix, Minecraft mc, int scaledWidth, int scaledHeight) {
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)WATER_BAR);
        MobEffectInstance effectInstance = mc.f_91074_.m_21124_(HomeostaticEffects.THIRST);
        if (WaterHud.hasAirBar((Player)player) || WaterHud.isRidingHighHealth((Player)player)) {
            matrix.m_85837_(0.0, -9.0, 0.0);
        }
        player.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> {
            int offsetY;
            int waterLevel = data.getWaterLevel();
            float waterSaturationLevel = data.getWaterSaturationLevel();
            int offsetX = scaledWidth / 2 + 91;
            int pY = offsetY = scaledHeight - 50;
            int pV = 0;
            int pU = 0;
            int pUOffset = 0;
            if (effectInstance != null) {
                pU += 18;
                pUOffset += 9;
            }
            for (int i = 0; i < 10; ++i) {
                int pX = offsetX - i * 8 - 9;
                this.m_93228_(matrix, pX, pY, pUOffset + 36, pV, 9, 9);
                if (waterSaturationLevel <= 0.0f && tickCount % (waterLevel * 3 + 1) == 0) {
                    pY = offsetY + (Homeostatic.RANDOM.nextInt(3) - 1);
                }
                if (i * 2 + 1 < waterLevel) {
                    this.m_93228_(matrix, pX, pY, pU, pV, 9, 9);
                }
                if (i * 2 + 1 == waterLevel) {
                    this.m_93228_(matrix, pX, pY, pU + 9, pV, 9, 9);
                }
                if ((float)(i * 2 + 1) < waterSaturationLevel) {
                    this.m_93228_(matrix, pX, pY - 1, pU, pV + 9, 9, 9);
                    this.m_93228_(matrix, pX, pY + 1, pU + 9, pV + 9, 9, 9);
                }
                if ((float)(i * 2 + 1) != waterSaturationLevel) continue;
                this.m_93228_(matrix, pX, pY, pU, pV + 9, 9, 9);
            }
        });
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ++tickCount;
        tickCount %= 1200;
    }

    public static boolean hasAirBar(Player player) {
        int maxAirSupply = player.m_6062_();
        int airSupply = Math.min(player.m_20146_(), maxAirSupply);
        return player.m_204029_(FluidTags.f_13131_) || airSupply < maxAirSupply;
    }

    public static boolean isRidingHighHealth(Player player) {
        boolean isMounted = player.m_20202_() instanceof LivingEntity;
        if (isMounted) {
            return ((LivingEntity)player.m_20202_()).m_21233_() >= 22.0f;
        }
        return false;
    }
}

