/*
 * Decompiled with CFR 0.152.
 */
package homeostatic.util;

import homeostatic.Homeostatic;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.common.water.WaterInfo;
import homeostatic.config.ConfigHandler;
import homeostatic.network.NetworkHandler;
import homeostatic.network.WaterData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.network.PacketDistributor;

public class WaterHelper {
    public static void updateWaterInfo(ServerPlayer sp, float sweatLevel) {
        sp.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> {
            WaterInfo waterInfo = new WaterInfo(data.getWaterLevel(), data.getWaterSaturationLevel(), data.getWaterExhaustionLevel());
            waterInfo.update(sweatLevel);
            data.setWaterData(waterInfo);
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new WaterData(waterInfo));
        });
    }

    public static void drinkWater(ServerPlayer sp, boolean isDirty, boolean update) {
        sp.getCapability(CapabilityRegistry.WATER_CAPABILITY).ifPresent(data -> {
            if (isDirty) {
                data.increaseWaterLevel();
            } else {
                data.increaseCleanWaterLevel();
                data.increaseSaturationLevel();
            }
            if (isDirty && Homeostatic.RANDOM.nextFloat() < ConfigHandler.Server.effectChance()) {
                sp.m_7292_(new MobEffectInstance(HomeostaticEffects.THIRST, ConfigHandler.Server.effectDuration(), ConfigHandler.Server.effectPotency(), false, false, false));
            }
            if (update) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new WaterData(new WaterInfo(data.getWaterLevel(), data.getWaterSaturationLevel(), data.getWaterExhaustionLevel())));
            }
        });
    }
}

