/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.client.render;

import com.kirdow.itemlocks.ItemLocks;
import com.kirdow.itemlocks.client.LockManager;
import com.kirdow.itemlocks.client.input.KeyBindings;
import com.kirdow.itemlocks.client.render.ELockModifier;
import com.kirdow.itemlocks.client.render.Res;
import com.kirdow.itemlocks.config.state.ConfigStates;
import com.kirdow.itemlocks.proxy.Components;
import com.kirdow.itemlocks.util.Core;
import com.kirdow.itemlocks.util.enums.ContainerType;
import com.kirdow.itemlocks.util.reflect.ReflectUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RenderContainer {
    private static LockManager manager = null;
    public static final String ILTTP = "\u00a76ItemLocks\u00a78: \u00a7a";
    private static final PoseStack ms = new PoseStack();

    private static LockManager getManager() {
        if (manager != null) {
            return manager;
        }
        manager = Components.getComponent(LockManager.class);
        return manager;
    }

    public static void drawScreen(AbstractContainerScreen screen) {
        int y;
        int x;
        LockManager manager = RenderContainer.getManager();
        Slot hoveredSlot = screen.getSlotUnderMouse();
        boolean mode = KeyBindings.isToggle();
        GlStateManager.m_84525_();
        GlStateManager.m_84266_((int)256, (boolean)false);
        Core.mc().f_90987_.m_118506_(Res.TEXTURE_ICONS).m_117966_();
        NonNullList slots = screen.m_6262_().f_38839_;
        ContainerType containerType = ContainerType.match(screen);
        Inventory playerInventory = Core.mc().f_91074_.m_150109_();
        boolean bypass = KeyBindings.isBypass() || ConfigStates.Action.bypassAll() || !screen.m_6262_().m_142621_().m_41619_() && ConfigStates.Action.bypassHeld();
        boolean unlockedSlots = false;
        for (Slot slot : slots) {
            if (slot.f_40218_ != playerInventory || !manager.isLockedSlot(containerType, slot.getSlotIndex())) continue;
            boolean unlock = mode && hoveredSlot == slot;
            x = slot.f_40220_;
            y = slot.f_40221_;
            if (bypass && hoveredSlot == slot) {
                RenderContainer.drawLock(x, y, unlock ? ELockModifier.LiftedUnlocked : ELockModifier.Unlocked);
                continue;
            }
            if (slot.m_6657_()) {
                RenderContainer.drawLock(x, y, unlock ? ELockModifier.LiftedLocked : ELockModifier.Locked);
                continue;
            }
            RenderContainer.drawLock(x, y, unlock ? ELockModifier.LiftedUnlocked : ELockModifier.Unlocked);
            unlockedSlots = true;
        }
        if (unlockedSlots && ItemLocks.hasTips()) {
            x = 8;
            y = 8 + ReflectUtil.getYSize(screen);
            String[] strs = Core.player().m_150109_().m_36056_() != null ? new String[]{"\u00a76ItemLocks\u00a78: \u00a7aEmpty slots with a lock are", "shown unlocked, allowing to place", "held items in those slots!"} : new String[]{"\u00a76ItemLocks\u00a78: \u00a7aUnlock empty slots by holding", "lock key and pressing LMB"};
            for (String str : strs) {
                Core.mc().f_91062_.m_92763_(ms, (Component)Component.m_237113_((String)str), (float)x, (float)y, ChatFormatting.GREEN.m_126665_().intValue());
                Objects.requireNonNull(Core.mc().f_91062_);
                y += 9 + 2;
            }
        }
    }

    public static void drawHotbar(LockManager manager) {
        int width = Core.mc().m_91268_().m_85445_();
        int height = Core.mc().m_91268_().m_85446_();
        int x = width / 2 - 87;
        int y = height - 18;
        GlStateManager.m_84507_();
        Core.mc().f_90987_.m_118506_(Res.TEXTURE_ICONS).m_117966_();
        for (int i = 0; i < 9; ++i) {
            if (!manager.isLockedSlot(ContainerType.HOTBAR, i)) continue;
            if (!((ItemStack)Core.player().m_150109_().f_35974_.get(i)).m_41619_()) {
                RenderContainer.drawLock(x + i * 20, y, KeyBindings.isBypass() ? ELockModifier.LiftedLocked : ELockModifier.Locked);
                continue;
            }
            RenderContainer.drawLock(x + i * 20, y, ELockModifier.Unlocked);
        }
        GlStateManager.m_84513_();
    }

    public static void drawLock(int x, int y, ELockModifier modifier) {
        int posX = x + 12;
        int posY = y - 4;
        switch (modifier) {
            case Locked: {
                RenderContainer.drawScaledCustomSizeModalRect(posX, posY, 0, 16, 6, 11, 6.0f, 11.0f, 256.0f, 256.0f);
                break;
            }
            case Unlocked: {
                RenderContainer.drawScaledCustomSizeModalRect(posX, posY, 16, 16, 10, 11, 10.0f, 11.0f, 256.0f, 256.0f);
                break;
            }
            case LiftedLocked: {
                RenderContainer.drawScaledCustomSizeModalRect(posX, posY - 1, 0, 16, 6, 5, 6.0f, 5.0f, 256.0f, 256.0f);
                RenderContainer.drawScaledCustomSizeModalRect(posX, posY + 5, 0, 21, 6, 6, 6.0f, 6.0f, 256.0f, 256.0f);
                break;
            }
            case LiftedUnlocked: {
                RenderContainer.drawScaledCustomSizeModalRect(posX, posY - 1, 16, 16, 10, 5, 10.0f, 5.0f, 256.0f, 256.0f);
                RenderContainer.drawScaledCustomSizeModalRect(posX, posY + 5, 16, 21, 6, 6, 6.0f, 6.0f, 256.0f, 256.0f);
            }
        }
    }

    public static void drawScaledCustomSizeModalRect(float x, float y, int u, int v, int uWidth, int vHeight, float width, float height, float tileWidth, float tileHeight) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)Res.TEXTURE_ICONS);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69465_();
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_((double)x, (double)(y + height), 0.0).m_7421_((float)u * f, ((float)v + (float)vHeight) * f1).m_5752_();
        bufferbuilder.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_(((float)u + (float)uWidth) * f, ((float)v + (float)vHeight) * f1).m_5752_();
        bufferbuilder.m_5483_((double)(x + width), (double)y, 0.0).m_7421_(((float)u + (float)uWidth) * f, (float)v * f1).m_5752_();
        bufferbuilder.m_5483_((double)x, (double)y, 0.0).m_7421_((float)u * f, (float)v * f1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }
}

