/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class LockOptions {
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT = (Client)clientSpecPair.getKey();
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getValue();
    }

    public static class Client {
        private static final boolean defaultNotifyGlobal = true;
        private static final boolean defaultNotifyChat = true;
        private static final boolean defaultNotifyHud = true;
        private static final boolean defaultBypassHeld = false;
        private static final boolean defaultBypassAll = false;
        private static final boolean defaultEmptyLock = false;
        public final ForgeConfigSpec.ConfigValue<Boolean> notifyGlobal;
        public final ForgeConfigSpec.ConfigValue<Boolean> notifyChat;
        public final ForgeConfigSpec.ConfigValue<Boolean> notifyHud;
        public final ForgeConfigSpec.ConfigValue<Boolean> bypassHeld;
        public final ForgeConfigSpec.ConfigValue<Boolean> bypassAll;
        public final ForgeConfigSpec.ConfigValue<Boolean> emptyLock;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("config.ktnilcks.section.versions");
            this.notifyGlobal = builder.comment("config.ktnilcks.notify.global.long").define("config.ktnilcks.notify.global.short", true);
            this.notifyChat = builder.comment("config.ktnilcks.notify.chat.long").define("config.ktnilcks.notify.chat.short", true);
            this.notifyHud = builder.comment("config.ktnilcks.notify.hud.long").define("config.ktnilcks.notify.hud.short", true);
            builder.pop();
            builder.push("config.ktnilcks.section.actions");
            this.bypassHeld = builder.comment("config.ktnilcks.action.bypassheld.long").define("config.ktnilcks.action.bypassheld.short", false);
            this.bypassAll = builder.comment("config.ktnilcks.action.bypassall.long").define("config.ktnilcks.action.bypassall.short", false);
            this.emptyLock = builder.comment("config.ktnilcks.action.emptylock.long").define("config.ktnilcks.action.emptylock.short", false);
            builder.pop();
        }
    }
}

