/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.config.gui;

import com.kirdow.itemlocks.config.LockOptions;
import com.kirdow.itemlocks.util.Core;
import com.kirdow.itemlocks.util.reflect.ReflectClass;
import com.kirdow.itemlocks.util.reflect.ReflectField;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.common.ForgeConfigSpec;

public class LocksConfigGui
extends Screen {
    private int centerX;
    private int centerY;
    private int marginX;
    private int marginY;
    private int mouseX;
    private int mouseY;
    private Screen previousMenu;
    private Button globalBtn;
    private Button chatBtn;
    private Button bypassHeldBtn;
    private Button bypassAllBtn;
    private int buttonY;
    private static ReflectField isHoveredField = ReflectClass.forClass(Widget.class).getDeclaredFieldAt(7);
    private Component activeTooltip;

    public LocksConfigGui() {
        this(null);
    }

    public LocksConfigGui(Screen previous) {
        super((Component)Component.m_237115_((String)"config.ktnilcks.base.config_title"));
        this.previousMenu = previous;
    }

    private int getOptionPosition(int index, boolean isText) {
        return this.centerY / 2 + 24 * index + (isText ? 6 : 0);
    }

    private void resetButtonPlacement() {
        this.buttonY = 0;
    }

    private Button nextButton(String titleCode, String hoverCode, boolean state, Supplier<Boolean> stateCallback) {
        Button result = new Button(this.centerX + 10, this.getOptionPosition(this.buttonY, false), 100, 20, this.getMessageFromState(state), btn -> {
            boolean newState = (Boolean)stateCallback.get();
            btn.m_93666_(this.getMessageFromState((Boolean)stateCallback.get()));
        });
        return result;
    }

    public void m_7856_() {
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.marginX = 10;
        this.marginY = 10;
        MutableComponent backText = Component.m_237115_((String)"gui.back");
        this.m_142416_((GuiEventListener)new Button(10, 10, Core.mc().f_91062_.m_92895_(backText.getString()) + 12, 20, (Component)backText, btn -> this.m_7379_()));
        this.globalBtn = this.addRenderableToggle(1, LockOptions.CLIENT.notifyGlobal);
        this.chatBtn = this.addRenderableToggle(2, LockOptions.CLIENT.notifyChat);
        this.bypassHeldBtn = this.addRenderableToggle(5, LockOptions.CLIENT.bypassHeld);
        this.bypassAllBtn = this.addRenderableToggle(6, LockOptions.CLIENT.bypassAll);
        this.chatBtn.f_93623_ = (Boolean)LockOptions.CLIENT.notifyGlobal.get();
    }

    private Button addRenderableToggle(int pos, ForgeConfigSpec.ConfigValue<Boolean> option) {
        Button button = new Button(this.centerX + 10, this.getOptionPosition(pos, false), 100, 20, this.getMessageFromState((Boolean)option.get()), btn -> {
            boolean newState = (Boolean)option.get() == false;
            option.set((Object)newState);
            btn.m_93666_(this.getMessageFromState(newState));
        });
        this.m_142416_((GuiEventListener)button);
        return button;
    }

    private Component getMessageFromState(boolean state) {
        return Component.m_237115_((String)(state ? "gui.yes" : "gui.no")).m_6270_(Style.f_131099_.m_131140_(state ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED));
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.m_96558_(matrixStack, 0);
        MutableComponent titleText = Component.m_237115_((String)"config.ktnilcks.base.config_title");
        Font font = Core.mc().f_91062_;
        font.m_92763_(matrixStack, (Component)titleText, (float)((this.f_96543_ - font.m_92895_(titleText.getString())) / 2), 20.0f, 0xF0F0F0);
        this.drawButtonPrefix(matrixStack, 0, "config.ktnilcks.section.versions", null);
        this.drawButtonPrefix(matrixStack, 1, "config.ktnilcks.notify.global.short", "config.ktnilcks.notify.global.long");
        this.drawButtonPrefix(matrixStack, 2, "config.ktnilcks.notify.chat.short", "config.ktnilcks.notify.chat.long");
        this.drawButtonPrefix(matrixStack, 4, "config.ktnilcks.section.actions", null);
        this.drawButtonPrefix(matrixStack, 5, "config.ktnilcks.action.bypassheld.short", "config.ktnilcks.action.bypassheld.long");
        this.drawButtonPrefix(matrixStack, 6, "config.ktnilcks.action.bypassall.short", "config.ktnilcks.action.bypassall.long");
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != null) {
            List hoverTextLines = font.m_92923_((FormattedText)this.activeTooltip, 134);
            this.m_96617_(matrixStack, hoverTextLines, mouseX, mouseY);
        }
    }

    private void drawButtonPrefix(PoseStack ms, int index, String key, String hover) {
        Style style = Style.f_131099_.m_131140_(ChatFormatting.WHITE);
        if (hover != null) {
            style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)hover).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN))));
        }
        this.drawButtonPrefix(ms, (Component)Component.m_237115_((String)key).m_6270_(style), index, hover == null);
    }

    private void drawButtonPrefix(PoseStack matrixStack, Component text, int index, boolean isTitle) {
        block5: {
            block4: {
                Font font = Core.mc().f_91062_;
                int textWidth = font.m_92895_(text.getString());
                int x = this.centerX - (isTitle ? textWidth / 2 : textWidth + 10);
                int y = this.getOptionPosition(index, true);
                Core.mc().f_91062_.m_92763_(matrixStack, text, (float)x, (float)y, 0xF0F0F0);
                if (this.mouseX < x - 10 || this.mouseY < y - 10 || this.mouseX > x + textWidth + 10) break block4;
                Objects.requireNonNull(font);
                if (this.mouseY <= y + 9 + 10) break block5;
            }
            return;
        }
        HoverEvent event = text.m_7383_().m_131186_();
        if (event != null && event.m_130820_() == HoverEvent.Action.f_130831_) {
            this.activeTooltip = (Component)event.m_130823_(HoverEvent.Action.f_130831_);
        }
    }

    public void m_7379_() {
        if (this.previousMenu != null) {
            Core.mc().m_91152_(this.previousMenu);
        } else {
            super.m_7379_();
        }
    }
}

