/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.forge;

import com.kirdow.itemlocks.ItemLocks;
import com.kirdow.itemlocks.Logger;
import com.kirdow.itemlocks.client.LockManager;
import com.kirdow.itemlocks.client.data.LockService;
import com.kirdow.itemlocks.client.input.KeyBindings;
import com.kirdow.itemlocks.client.render.RenderContainer;
import com.kirdow.itemlocks.client.update.UpdateManager;
import com.kirdow.itemlocks.common.KeyboardEvent;
import com.kirdow.itemlocks.common.MouseEvent;
import com.kirdow.itemlocks.common.Overlay;
import com.kirdow.itemlocks.common.Reference;
import com.kirdow.itemlocks.config.LockOptions;
import com.kirdow.itemlocks.config.gui.LocksConfigGui;
import com.kirdow.itemlocks.forge.ClientHelper;
import com.kirdow.itemlocks.forge.LockRepositoryForge;
import com.kirdow.itemlocks.forge.ModEvents;
import com.kirdow.itemlocks.forge.ReferenceForge;
import com.kirdow.itemlocks.proxy.Components;
import com.kirdow.itemlocks.util.Core;
import com.kirdow.itemlocks.util.enums.ContainerType;
import com.kirdow.itemlocks.util.locks.InventoryHelper;
import com.kirdow.itemlocks.util.reflect.ReflectClass;
import java.io.File;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;

@Mod(value="ktnilcks")
public class ItemLocksForge {
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger((String)String.format("%s", "ktnilcks"));

    public ItemLocksForge() {
        Logger.setLogger(arg_0 -> ((org.apache.logging.log4j.Logger)LOGGER).info(arg_0), arg_0 -> ((org.apache.logging.log4j.Logger)LOGGER).debug(arg_0), arg_0 -> ((org.apache.logging.log4j.Logger)LOGGER).error(arg_0), arg_0 -> ((org.apache.logging.log4j.Logger)LOGGER).warn(arg_0));
        if (FMLEnvironment.dist != Dist.CLIENT) {
            Logger.info("Disabled because not running on the client.", new Object[0]);
            return;
        }
        ReflectClass.forClass(Reference.class).getDeclaredFieldByName("_i").set(null, new ReferenceForge());
        ReflectClass.forClass(Reference.class).getDeclaredFieldByName("_lockRepository").set(null, new LockRepositoryForge());
        Logger.info("Preparing mod config directory", new Object[0]);
        ItemLocks.modFolder = new File(FMLPaths.CONFIGDIR.get().toFile(), "ItemLocks");
        if (!ItemLocks.modFolder.exists()) {
            Logger.info("Creating config directory", new Object[0]);
            if (!ItemLocks.modFolder.mkdir()) {
                Logger.error("Failed creating config directory: %s", ItemLocks.modFolder.getAbsolutePath());
            }
        }
        ReflectClass.forClass(Components.class).getDeclaredMethodByName("registerComponents", new Class[0]).invoke(null, new Object[0]);
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register(ModEvents.class);
        bus.register(Overlay.class);
        KeyBindings.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)LockOptions.CLIENT_SPEC);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, ClientHelper::createConfigGuiFactory);
    }

    private LockManager getLockManager() {
        return Components.getComponent(LockManager.class);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        UpdateManager.queryOutdated();
    }

    @SubscribeEvent
    public void onKeyPress(InputEvent.Key event) {
        if (event.getAction() != 1) {
            return;
        }
        if (KeyBindings.keyShowOptions.m_90832_(event.getKey(), event.getScanCode()) && !Core.isScreen()) {
            Core.mc().m_91152_((Screen)new LocksConfigGui());
        }
    }

    @SubscribeEvent
    public void onPlayerConnect(ClientPlayerNetworkEvent.LoggingIn event) {
        UpdateManager.UPDATE_MANAGER.checkAndNotifyAsync();
    }

    @SubscribeEvent
    public void onContainerForeground(ContainerScreenEvent.Render.Foreground event) {
        AbstractContainerScreen container = event.getContainerScreen();
        if (container == null) {
            return;
        }
        RenderContainer.drawScreen(container);
    }

    @SubscribeEvent
    public void onScreenMouseEvent(ScreenEvent event) {
        if (!(event instanceof ScreenEvent.MouseButtonPressed) && !(event instanceof ScreenEvent.MouseButtonReleased) || !event.isCancelable()) {
            return;
        }
        int button = event instanceof ScreenEvent.MouseButtonPressed ? ((ScreenEvent.MouseButtonPressed)event).getButton() : ((ScreenEvent.MouseButtonReleased)event).getButton();
        boolean press = event instanceof ScreenEvent.MouseButtonPressed;
        MouseEvent mouseEvent = new MouseEvent(press ? MouseEvent.EMouseAction.Click : MouseEvent.EMouseAction.Release, MouseEvent.EMouseButton.of(button));
        if (this.getLockManager().mouseEvent(mouseEvent)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onScreenKeyboardEvent(ScreenEvent.KeyPressed event) {
        KeyboardEvent keyboardEvent = new KeyboardEvent(event.getKeyCode(), event.getScanCode(), true);
        if (this.getLockManager().keyboardEvent(keyboardEvent)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (!ItemLocks.hasTips()) {
            return;
        }
        Player player = event.getEntity();
        if (player != Core.player() || !Core.isPlayer()) {
            return;
        }
        if (!Core.isScreen(AbstractContainerScreen.class)) {
            return;
        }
        AbstractContainerScreen gui = (AbstractContainerScreen)Core.screen();
        ContainerType type = ContainerType.match(gui);
        Slot slot = gui.getSlotUnderMouse();
        if (slot == null || slot.f_40218_ != Core.player().m_150109_()) {
            return;
        }
        if (slot.m_7993_() != event.getItemStack()) {
            return;
        }
        boolean empty = !slot.m_6657_();
        boolean toggleKey = KeyBindings.isToggle();
        int slotIndex = slot.getSlotIndex();
        boolean shouldBypass = KeyBindings.isBypass() || empty;
        LockManager manager = Components.getComponent(LockManager.class);
        String lockStr = KeyBindings.keyLockHold.getKey().m_84875_().getString().toUpperCase();
        String bypassStr = KeyBindings.keyLockBypassHold.getKey().m_84875_().getString().toUpperCase();
        List tooltip = event.getToolTip();
        if (!toggleKey) {
            boolean locked;
            boolean bl = locked = !shouldBypass && manager.isLockedSlot(type, slotIndex);
            if (shouldBypass) {
                tooltip.add(Component.m_237113_((String)"\u00a76ItemLocks\u00a78: \u00a7aBypass active!"));
            } else if (locked) {
                tooltip.add(Component.m_237113_((String)("\u00a76ItemLocks\u00a78: \u00a7aUnlock: Hold " + lockStr + " + Press LMB!")));
                tooltip.add(Component.m_237113_((String)("\u00a76ItemLocks\u00a78: \u00a7aBypass: Hold " + bypassStr + "!")));
            } else {
                tooltip.add(Component.m_237113_((String)("\u00a76ItemLocks\u00a78: \u00a7aLock: Hold " + lockStr + " + Press LMB!")));
                tooltip.add(Component.m_237113_((String)("\u00a76ItemLocks\u00a78: \u00a7aBypass: Hold " + bypassStr + "!")));
            }
        } else {
            int slotRaw = InventoryHelper.getSlotFromIncrement(type, slotIndex);
            boolean isLocked = manager.isLockedSlotRaw(slotRaw);
            if (isLocked) {
                tooltip.add(Component.m_237113_((String)"\u00a76ItemLocks\u00a78: \u00a7aUnlock: Press LMB"));
            } else {
                tooltip.add(Component.m_237113_((String)"\u00a76ItemLocks\u00a78: \u00a7aLock: Press LMB"));
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        LockService.getService().onWorldLoad();
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        LockService.getService().onWorldUnload();
    }

    @SubscribeEvent
    public void onNetworkEstablished(ClientPlayerNetworkEvent.LoggingIn event) {
        Components.getComponent(LockManager.class).onNetworkEstablished(event.getConnection());
    }
}

