/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effectcreators;

import ivorius.pandorasbox.effectcreators.PBEffectCreator;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectMulti;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class PBECRegistry {
    private static ArrayList<String> goodCreators = new ArrayList();
    private static ArrayList<String> badCreators = new ArrayList();
    private static Hashtable<String, PBEffectCreator> effectCreators = new Hashtable();

    public static void register(PBEffectCreator creator, String id, boolean good) {
        (good ? goodCreators : badCreators).add(id);
        effectCreators.put(id, creator);
    }

    public static String getID(PBEffectCreator creator) {
        for (String id : effectCreators.keySet()) {
            if (!effectCreators.get(id).equals(creator)) continue;
            return id;
        }
        return null;
    }

    public static PBEffectCreator effectCreatorWithName(String name) {
        return effectCreators.get(name);
    }

    public static boolean hasEffect(String name) {
        return effectCreators.containsKey(name);
    }

    public static boolean isEffectGood(String name) {
        return goodCreators.contains(name);
    }

    public static PBEffectCreator randomEffectCreatorOfType(Random random, boolean good) {
        ArrayList<String> list = good ? goodCreators : badCreators;
        return effectCreators.get(list.get(random.nextInt(list.size())));
    }

    public static PBEffect createEffect(World world, Random random, double x, double y, double z, String name) {
        PBEffectCreator creator = PBECRegistry.effectCreatorWithName(name);
        if (creator != null) {
            return PBECRegistry.constructEffectSafe(creator, world, x, y, z, random);
        }
        return null;
    }

    public static PBEffect createRandomEffectOfType(World world, Random random, double x, double y, double z, boolean good) {
        PBEffectCreator creator = PBECRegistry.randomEffectCreatorOfType(random, good);
        if (creator != null) {
            return PBECRegistry.constructEffectSafe(creator, world, x, y, z, random);
        }
        return null;
    }

    public static PBEffect createRandomEffect(World world, Random random, double x, double y, double z, boolean multi) {
        float currentMinChance = 1.0f;
        ArrayList<PBEffect> effects = new ArrayList<PBEffect>();
        do {
            PBEffectCreator creator;
            PBEffect effect;
            if ((effect = PBECRegistry.constructEffectSafe(creator = PBECRegistry.randomEffectCreatorOfType(random, random.nextFloat() < 0.49f), world, x, y, z, random)) != null) {
                effects.add(effect);
            }
            currentMinChance = Math.min(currentMinChance, creator.chanceForMoreEffects(world, x, y, z, random));
        } while (random.nextFloat() < currentMinChance && effects.size() < 3 && multi);
        if (effects.size() == 1) {
            return (PBEffect)effects.get(0);
        }
        PBEffect[] effectArray = effects.toArray(new PBEffect[effects.size()]);
        int[] delays = new int[effectArray.length];
        for (int i = 0; i < delays.length; ++i) {
            delays[i] = i == 0 ? 0 : random.nextInt(60);
        }
        PBEffectMulti multiEffect = new PBEffectMulti(effectArray, delays);
        return multiEffect;
    }

    public static PBEffect constructEffectSafe(PBEffectCreator creator, World world, double x, double y, double z, Random random) {
        try {
            return creator.constructEffect(world, x, y, z, random);
        }
        catch (Exception ex) {
            System.out.println("PBEC failed! '" + PBECRegistry.getID(creator) + "'");
            ex.printStackTrace();
            return null;
        }
    }

    public static EntityPandorasBox spawnPandorasBox(World world, Random random, boolean multi, Entity entity) {
        PBEffect effect = PBECRegistry.createRandomEffect(world, random, entity.field_70165_t, entity.field_70163_u + 1.2, entity.field_70161_v, multi);
        return PBECRegistry.spawnPandorasBox(world, effect, entity);
    }

    public static EntityPandorasBox spawnPandorasBox(World world, Random random, String id, Entity entity) {
        PBEffect effect = PBECRegistry.createEffect(world, random, entity.field_70165_t, entity.field_70163_u + 1.2, entity.field_70161_v, id);
        return PBECRegistry.spawnPandorasBox(world, effect, entity);
    }

    public static EntityPandorasBox spawnPandorasBox(World world, PBEffect effect, Entity entity) {
        if (effect != null) {
            EntityPandorasBox entityPandorasBox = new EntityPandorasBox(world, effect);
            Vec3 look = entity.func_70040_Z();
            entityPandorasBox.func_70107_b(entity.field_70165_t + look.field_72450_a * 0.5, entity.field_70163_u + 1.2 + look.field_72448_b * 0.5, entity.field_70161_v + look.field_72449_c * 0.5);
            entityPandorasBox.field_70177_z = entity.field_70177_z + 180.0f;
            entityPandorasBox.beginFloatingAway();
            world.func_72838_d((Entity)entityPandorasBox);
            return entityPandorasBox;
        }
        return null;
    }

    public static Set<String> getAllIDs() {
        return effectCreators.keySet();
    }

    public static String[] getIDArray() {
        Set<String> allIDs = PBECRegistry.getAllIDs();
        return allIDs.toArray(new String[allIDs.size()]);
    }
}

