/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffectRegistry;
import ivorius.pandorasbox.effects.PBEffectSpawnEntityIDList;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class PBEffect {
    public String getEffectID() {
        return PBEffectRegistry.getEffectID(this);
    }

    public static String[] getNBTStrings(String id, NBTTagCompound compound) {
        NBTTagList nbtTagList = compound.func_150295_c(id, 8);
        String[] strings = new String[nbtTagList.func_74745_c()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = nbtTagList.func_150307_f(i);
        }
        return strings;
    }

    public static void setNBTStrings(String id, String[] strings, NBTTagCompound compound) {
        NBTTagList nbtTagList = new NBTTagList();
        for (String s : strings) {
            nbtTagList.func_74742_a((NBTBase)new NBTTagString(s));
        }
        compound.func_74782_a(id, (NBTBase)nbtTagList);
    }

    public static String[][] getNBTStrings2D(String id, NBTTagCompound compound) {
        NBTTagList nbtTagList = compound.func_150295_c(id, 10);
        String[][] strings = new String[nbtTagList.func_74745_c()][];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = PBEffect.getNBTStrings("Strings", nbtTagList.func_150305_b(i));
        }
        return strings;
    }

    public static void setNBTStrings2D(String id, String[][] strings, NBTTagCompound compound) {
        NBTTagList nbtTagList = new NBTTagList();
        for (String[] s : strings) {
            NBTTagCompound compound1 = new NBTTagCompound();
            PBEffect.setNBTStrings("Strings", s, compound1);
            nbtTagList.func_74742_a((NBTBase)compound1);
        }
        compound.func_74782_a(id, (NBTBase)nbtTagList);
    }

    public static ItemStack[] getNBTStacks(String id, NBTTagCompound compound) {
        NBTTagList nbtTagList = compound.func_150295_c(id, 10);
        ItemStack[] itemStacks = new ItemStack[nbtTagList.func_74745_c()];
        for (int i = 0; i < itemStacks.length; ++i) {
            itemStacks[i] = ItemStack.func_77949_a((NBTTagCompound)nbtTagList.func_150305_b(i));
        }
        return itemStacks;
    }

    public static void setNBTStacks(String id, ItemStack[] stacks, NBTTagCompound compound) {
        NBTTagList nbtTagList = new NBTTagList();
        for (ItemStack stack : stacks) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            stack.func_77955_b(tagCompound);
            nbtTagList.func_74742_a((NBTBase)tagCompound);
        }
        compound.func_74782_a(id, (NBTBase)nbtTagList);
    }

    public static Block[] getNBTBlocks(String id, NBTTagCompound compound) {
        NBTTagList nbtTagList = compound.func_150295_c(id, 8);
        Block[] blocks = new Block[nbtTagList.func_74745_c()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = (Block)Block.field_149771_c.func_82594_a(nbtTagList.func_150307_f(i));
        }
        return blocks;
    }

    public static void setNBTBlocks(String id, Block[] blocks, NBTTagCompound compound) {
        NBTTagList nbtTagList = new NBTTagList();
        for (Block b : blocks) {
            nbtTagList.func_74742_a((NBTBase)new NBTTagString(Block.field_149771_c.func_148750_c((Object)b)));
        }
        compound.func_74782_a(id, (NBTBase)nbtTagList);
    }

    public static long[] getNBTLongs(String id, NBTTagCompound compound) {
        NBTTagList nbtTagList = compound.func_150295_c(id, 8);
        long[] longs = new long[nbtTagList.func_74745_c()];
        for (int i = 0; i < longs.length; ++i) {
            int[] parts = nbtTagList.func_150306_c(i);
            longs[i] = (long)parts[0] + ((long)parts[1] << 32);
        }
        return longs;
    }

    public static void setNBTLongs(String id, long[] longs, NBTTagCompound compound) {
        NBTTagList nbtTagList = new NBTTagList();
        for (long l : longs) {
            int lower = (int)l;
            int upper = (int)(l >>> 32);
            nbtTagList.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{(int)l, (int)(l >>> 32)}));
        }
        compound.func_74782_a(id, (NBTBase)nbtTagList);
    }

    public static PotionEffect[] getNBTPotions(String id, NBTTagCompound compound) {
        NBTTagList nbtTagList = compound.func_150295_c(id, 8);
        PotionEffect[] potions = new PotionEffect[nbtTagList.func_74745_c()];
        for (int i = 0; i < potions.length; ++i) {
            potions[i] = PotionEffect.func_82722_b((NBTTagCompound)nbtTagList.func_150305_b(i));
        }
        return potions;
    }

    public static void setNBTPotions(String id, PotionEffect[] potions, NBTTagCompound compound) {
        NBTTagList nbtTagList = new NBTTagList();
        for (PotionEffect p : potions) {
            nbtTagList.func_74742_a((NBTBase)p.func_82719_a(new NBTTagCompound()));
        }
        compound.func_74782_a(id, (NBTBase)nbtTagList);
    }

    public static boolean setBlockSafe(World world, int x, int y, int z, Block block) {
        boolean safeSrc;
        boolean safeDest = world.func_147439_a(x, y, z) == Blocks.field_150350_a || world.func_147439_a(x, y, z).func_149712_f(world, x, y, z) >= 0.0f;
        boolean bl = safeSrc = block == Blocks.field_150350_a || block.func_149712_f(world, x, y, z) >= 0.0f;
        if (safeDest && safeSrc) {
            world.func_147465_d(x, y, z, block, 0, 3);
            return true;
        }
        return false;
    }

    public static boolean setBlockAndMetaSafe(World world, int x, int y, int z, Block id, int meta) {
        boolean safeSrc;
        boolean safeDest = world.func_147439_a(x, y, z) == Blocks.field_150350_a || world.func_147439_a(x, y, z).func_149712_f(world, x, y, z) >= 0.0f;
        boolean bl = safeSrc = id == Blocks.field_150350_a || id.func_149712_f(world, x, y, z) >= 0.0f;
        if (safeDest && safeSrc) {
            world.func_147465_d(x, y, z, id, meta, 3);
            return true;
        }
        return false;
    }

    public static boolean setBlockVarying(World world, int x, int y, int z, Block block, int unified) {
        return PBEffect.setBlockAndMetaSafe(world, x, y, z, block, PandorasBoxHelper.getRandomBlockMetadata(world.field_73012_v, block, unified));
    }

    public static EntityPlayer getRandomNearbyPlayer(World world, EntityPandorasBox box) {
        return (EntityPlayer)world.func_72857_a(EntityPlayer.class, box.field_70121_D.func_72314_b(30.0, 30.0, 30.0), (Entity)box);
    }

    public static EntityPlayer getPlayer(World world, EntityPandorasBox box) {
        return PBEffect.getRandomNearbyPlayer(world, box);
    }

    public boolean isBlockAnyOf(Block block, Block ... blocks) {
        for (Block block1 : blocks) {
            if (block != block1) continue;
            return true;
        }
        return false;
    }

    public Entity lazilySpawnEntity(World world, EntityPandorasBox box, Random random, String entityID, float chance, int x, int y, int z) {
        Entity entity;
        if (random.nextFloat() < chance && (entity = PBEffectSpawnEntityIDList.createEntity(world, box, random, entityID, x, y, z)) != null) {
            world.func_72838_d(entity);
            return entity;
        }
        return null;
    }

    public boolean canSpawnEntity(World world, Block block, int x, int y, int z) {
        if (world.field_72995_K) {
            return false;
        }
        if (block.getLightOpacity((IBlockAccess)world, x, y, z) > 0) {
            return false;
        }
        return world.func_147445_c(x, y - 1, z, false);
    }

    public boolean canSpawnFlyingEntity(World world, Block block, int x, int y, int z) {
        if (world.field_72995_K) {
            return false;
        }
        return block.getLightOpacity((IBlockAccess)world, x, y, z) <= 0 && world.getBlockLightOpacity(x, y - 1, z) <= 0 && world.getBlockLightOpacity(x, y - 2, z) <= 0;
    }

    public void addPotionEffectDuration(EntityLivingBase entity, PotionEffect potionEffect) {
        if (entity.func_70687_e(potionEffect)) {
            PotionEffect prevEffect;
            boolean addNewEffect = true;
            if (entity.func_82165_m(potionEffect.func_76456_a()) && (prevEffect = entity.func_70660_b(Potion.field_76425_a[potionEffect.func_76456_a()])).func_76458_c() == potionEffect.func_76458_c()) {
                int duration = prevEffect.func_76459_b() + potionEffect.func_76459_b();
                PotionEffect combined = new PotionEffect(potionEffect.func_76456_a(), duration, potionEffect.func_76458_c(), potionEffect.func_82720_e());
                entity.func_70690_d(combined);
            }
            if (addNewEffect) {
                entity.func_70690_d(potionEffect);
            }
        }
    }

    public abstract void doTick(EntityPandorasBox var1, int var2);

    public abstract boolean isDone(EntityPandorasBox var1, int var2);

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract boolean canGenerateMoreEffectsAfterwards(EntityPandorasBox var1);
}

