/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectEntityBased;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PBEffectEntitiesBuff
extends PBEffectEntityBased {
    public PotionEffect[] effects;

    public PBEffectEntitiesBuff() {
    }

    public PBEffectEntitiesBuff(int maxTicksAlive, double range, PotionEffect[] effects) {
        super(maxTicksAlive, range);
        this.effects = effects;
    }

    @Override
    public void affectEntity(World world, EntityPandorasBox box, Random random, EntityLivingBase entity, double newRatio, double prevRatio, double strength) {
        for (PotionEffect effect : this.effects) {
            int prevDuration = MathHelper.func_76128_c((double)(prevRatio * strength * (double)effect.func_76459_b()));
            int newDuration = MathHelper.func_76128_c((double)(newRatio * strength * (double)effect.func_76459_b()));
            int duration = newDuration - prevDuration;
            if (duration <= 0) continue;
            PotionEffect curEffect = new PotionEffect(effect.func_76456_a(), duration, effect.func_76458_c(), effect.func_82720_e());
            this.addPotionEffectDuration(entity, curEffect);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        PBEffectEntitiesBuff.setNBTPotions("potions", this.effects, compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.effects = PBEffectEntitiesBuff.getNBTPotions("potions", compound);
    }
}

