/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.PandorasBoxHelper;
import ivorius.pandorasbox.effects.PBEffect;
import ivorius.pandorasbox.effects.PBEffectGenerateByStructure;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import ivorius.pandorasbox.weighted.WeightedBlock;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PBEffectGenCreativeTowers
extends PBEffectGenerateByStructure {
    public PBEffectGenCreativeTowers() {
    }

    public PBEffectGenCreativeTowers(int maxTicksAlive) {
        super(maxTicksAlive);
    }

    public void createRandomStructures(Random random, int number, double range, Collection<WeightedBlock> blocks) {
        this.structures = new PBEffectGenerateByStructure.Structure[number];
        for (int i = 0; i < number; ++i) {
            this.structures[i] = this.createStructure();
            PBEffectGenCreativeTowers.applyRandomProperties(this.structures[i], range, random);
            ((StructureCreativeTower)this.structures[i]).blocks = PandorasBoxHelper.getRandomBlockList(random, blocks);
        }
    }

    @Override
    public void generateStructure(World world, EntityPandorasBox entity, Random random, PBEffectGenerateByStructure.Structure structure, int x, int y, int z, float newRatio, float prevRatio) {
        if (!world.field_72995_K) {
            int prevY;
            StructureCreativeTower structureCreativeTower = (StructureCreativeTower)structure;
            int towerHeight = world.func_72800_K();
            int newY = MathHelper.func_76141_d((float)((float)towerHeight * newRatio));
            for (int towerY = prevY = MathHelper.func_76141_d((float)((float)towerHeight * prevRatio)); towerY < newY; ++towerY) {
                Block block = structureCreativeTower.blocks[random.nextInt(structureCreativeTower.blocks.length)];
                PBEffectGenCreativeTowers.setBlockVarying(world, x + structure.x, towerY, z + structure.z, block, structure.unifiedSeed);
            }
        }
    }

    @Override
    public StructureCreativeTower createStructure() {
        return new StructureCreativeTower();
    }

    public static class StructureCreativeTower
    extends PBEffectGenerateByStructure.Structure {
        public Block[] blocks;

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            super.writeToNBT(compound);
            PBEffect.setNBTBlocks("blocks", this.blocks, compound);
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            super.readFromNBT(compound);
            this.blocks = PBEffect.getNBTBlocks("blocks", compound);
        }
    }
}

