/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerate2D;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class PBEffectGenHeightNoise
extends PBEffectGenerate2D {
    public int minShift;
    public int maxShift;
    public int minTowerSize;
    public int maxTowerSize;
    public int blockSize;

    public PBEffectGenHeightNoise() {
    }

    public PBEffectGenHeightNoise(int time, double range, int unifiedSeed, int minShift, int maxShift, int minTowerSize, int maxTowerSize, int blockSize) {
        super(time, range, 1, unifiedSeed);
        this.minShift = minShift;
        this.maxShift = maxShift;
        this.minTowerSize = minTowerSize;
        this.maxTowerSize = maxTowerSize;
        this.blockSize = blockSize;
    }

    @Override
    public void generateOnSurface(World world, EntityPandorasBox entity, Random random, int pass, int x, int baseY, int z, double range) {
        if (!world.field_72995_K) {
            int maxEffectY;
            int randomX = x - x % this.blockSize;
            int randomZ = z - z % this.blockSize;
            Random usedRandom = new Random(new Random(randomX).nextLong() ^ new Random(randomZ).nextLong());
            int shift = this.minShift + usedRandom.nextInt(this.maxShift - this.minShift + 1);
            int towerSize = this.minTowerSize + usedRandom.nextInt(this.maxTowerSize - this.minTowerSize + 1);
            int towerMinY = baseY - towerSize / 2;
            int minEffectY = towerMinY + Math.min(0, shift);
            List entityList = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((double)x - 2.0), (double)(minEffectY - 4), (double)((double)z - 3.0), (double)((double)x + 4.0), (double)((maxEffectY = towerMinY + towerSize + Math.max(0, shift)) + 4), (double)((double)z + 4.0)));
            if (entityList.size() == 0) {
                int y;
                Block[] ids = new Block[towerSize];
                int[] metas = new int[towerSize];
                for (y = 0; y < towerSize; ++y) {
                    ids[y] = world.func_147439_a(x, towerMinY + y, z);
                    metas[y] = world.func_72805_g(x, towerMinY + y, z);
                }
                for (y = 0; y < towerSize; ++y) {
                    PBEffectGenHeightNoise.setBlockAndMetaSafe(world, x, towerMinY + y + shift, z, ids[y], metas[y]);
                }
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("minShift", this.minShift);
        compound.func_74768_a("maxShift", this.maxShift);
        compound.func_74768_a("minTowerSize", this.minTowerSize);
        compound.func_74768_a("maxTowerSize", this.maxTowerSize);
        compound.func_74768_a("blockSize", this.blockSize);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.minShift = compound.func_74762_e("minShift");
        this.maxShift = compound.func_74762_e("maxShift");
        this.minTowerSize = compound.func_74762_e("minTowerSize");
        this.maxTowerSize = compound.func_74762_e("maxTowerSize");
        this.blockSize = compound.func_74762_e("blockSize");
    }
}

