/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenDome;
import ivorius.pandorasbox.effects.PBEffectNormal;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PBEffectGenWorldSnake
extends PBEffectNormal {
    public Block[] blocks;
    public int unifiedSeed;
    public double currentX;
    public double currentY;
    public double currentZ;
    public double size;
    public double speed;
    public float dirYaw;
    public float dirPitch;
    public float dirYawAcc;
    public float dirPitchAcc;

    public PBEffectGenWorldSnake() {
    }

    public PBEffectGenWorldSnake(int maxTicksAlive, Block[] blocks, int unifiedSeed, double currentX, double currentY, double currentZ, double size, double speed, float dirYaw, float dirPitch) {
        super(maxTicksAlive);
        this.blocks = blocks;
        this.unifiedSeed = unifiedSeed;
        this.currentX = currentX;
        this.currentY = currentY;
        this.currentZ = currentZ;
        this.size = size;
        this.speed = speed;
        this.dirYaw = dirYaw;
        this.dirPitch = dirPitch;
    }

    @Override
    public void doEffect(World world, EntityPandorasBox entity, Random random, float newRatio, float prevRatio) {
        if (!world.field_72995_K) {
            int requiredRange = MathHelper.func_76143_f((double)this.size);
            float f1 = MathHelper.func_76134_b((float)(-this.dirYaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = MathHelper.func_76126_a((float)(-this.dirYaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f3 = -MathHelper.func_76134_b((float)(-this.dirPitch * ((float)Math.PI / 180)));
            float f4 = MathHelper.func_76126_a((float)(-this.dirPitch * ((float)Math.PI / 180)));
            double dirX = (double)(f2 * f3) * this.speed;
            double dirY = (double)f4 * this.speed;
            double dirZ = (double)(f1 * f3) * this.speed;
            double newX = this.currentX + dirX;
            double newY = this.currentY + dirY;
            double newZ = this.currentZ + dirZ;
            int baseX = MathHelper.func_76128_c((double)newX);
            int baseY = MathHelper.func_76128_c((double)newY);
            int baseZ = MathHelper.func_76128_c((double)newZ);
            for (int x = -requiredRange; x <= requiredRange; ++x) {
                for (int y = -requiredRange; y <= requiredRange; ++y) {
                    for (int z = -requiredRange; z <= requiredRange; ++z) {
                        if (!PBEffectGenDome.isSpherePart((double)(baseX + x) + 0.5, (double)(baseY + y) + 0.5, (double)(baseZ + z) + 0.5, newX, newY, newZ, 0.0, this.size) || PBEffectGenDome.isSpherePart((double)(baseX + x) + 0.5, (double)(baseY + y) + 0.5, (double)(baseZ + z) + 0.5, this.currentX, this.currentY, this.currentZ, 0.0, this.size)) continue;
                        this.generateOnBlock(world, entity, random, x + baseX, y + baseY, z + baseZ);
                    }
                }
            }
            this.currentX = newX;
            this.currentY = newY;
            this.currentZ = newZ;
            this.dirYaw += this.dirYawAcc;
            this.dirPitch += this.dirPitchAcc;
            this.dirYawAcc += MathHelper.func_76131_a((float)((random.nextFloat() - random.nextFloat()) * 0.5f), (float)-10.0f, (float)10.0f);
            this.dirPitchAcc += MathHelper.func_76131_a((float)((random.nextFloat() - random.nextFloat()) * 0.5f), (float)-10.0f, (float)10.0f);
        }
    }

    public void generateOnBlock(World world, EntityPandorasBox entity, Random random, int x, int y, int z) {
        PBEffectGenWorldSnake.setBlockVarying(world, x, y, z, this.blocks[random.nextInt(this.blocks.length)], this.unifiedSeed);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        PBEffectGenWorldSnake.setNBTBlocks("block", this.blocks, compound);
        compound.func_74768_a("unifiedSeed", this.unifiedSeed);
        compound.func_74780_a("currentX", this.currentX);
        compound.func_74780_a("currentY", this.currentY);
        compound.func_74780_a("currentZ", this.currentZ);
        compound.func_74780_a("size", this.size);
        compound.func_74780_a("speed", this.speed);
        compound.func_74776_a("dirYaw", this.dirYaw);
        compound.func_74776_a("dirPitch", this.dirPitch);
        compound.func_74776_a("dirYawAcc", this.dirYawAcc);
        compound.func_74776_a("dirPitchAcc", this.dirPitchAcc);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.blocks = PBEffectGenWorldSnake.getNBTBlocks("block", compound);
        this.unifiedSeed = compound.func_74762_e("unifiedSeed");
        this.currentX = compound.func_74769_h("currentX");
        this.currentY = compound.func_74769_h("currentY");
        this.currentZ = compound.func_74769_h("currentZ");
        this.size = compound.func_74769_h("size");
        this.speed = compound.func_74769_h("speed");
        this.dirYaw = compound.func_74760_g("dirYaw");
        this.dirPitch = compound.func_74760_g("dirPitch");
        this.dirYawAcc = compound.func_74760_g("dirYawAcc");
        this.dirPitchAcc = compound.func_74760_g("dirPitchAcc");
    }
}

