/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectRangeBased;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class PBEffectGenerate2D
extends PBEffectRangeBased {
    public int unifiedSeed;

    public PBEffectGenerate2D() {
    }

    public PBEffectGenerate2D(int time, double range, int passes, int unifiedSeed) {
        super(time, range, passes);
        this.unifiedSeed = unifiedSeed;
    }

    @Override
    public void generateInRange(World world, EntityPandorasBox entity, Random random, double newRange, double prevRange, int pass) {
        int requiredRange = MathHelper.func_76128_c((double)newRange);
        int baseX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int baseY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int baseZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        for (int x = -requiredRange; x <= requiredRange; ++x) {
            for (int z = -requiredRange; z <= requiredRange; ++z) {
                double dist = MathHelper.func_76133_a((double)(x * x + z * z));
                if (!(dist <= newRange)) continue;
                if (dist > prevRange) {
                    this.generateOnSurface(world, entity, random, pass, x + baseX, baseY, z + baseZ, dist);
                    continue;
                }
                z = -z;
            }
        }
    }

    public abstract void generateOnSurface(World var1, EntityPandorasBox var2, Random var3, int var4, int var5, int var6, int var7, double var8);

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("unifiedSeed", this.unifiedSeed);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.unifiedSeed = compound.func_74762_e("unifiedSeed");
    }
}

