/*
 * Decompiled with CFR 0.152.
 */
package ivorius.pandorasbox.effects;

import ivorius.pandorasbox.effects.PBEffectGenerate;
import ivorius.pandorasbox.entitites.EntityPandorasBox;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class PBEffectGenerateByGenerator
extends PBEffectGenerate {
    public boolean requiresSolidGround;
    public double chancePerBlock;
    public int generatorFlags;

    public PBEffectGenerateByGenerator() {
    }

    public PBEffectGenerateByGenerator(int time, double range, int unifiedSeed, boolean requiresSolidGround, double chancePerBlock, int generatorFlags) {
        super(time, range, 1, unifiedSeed);
        this.requiresSolidGround = requiresSolidGround;
        this.chancePerBlock = chancePerBlock;
        this.generatorFlags = generatorFlags;
    }

    @Override
    public void generateOnBlock(World world, EntityPandorasBox entity, Random random, int pass, int x, int y, int z, double range) {
        if (!world.field_72995_K && random.nextDouble() < this.chancePerBlock) {
            Block block = world.func_147439_a(x, y, z);
            Block blockBelow = world.func_147439_a(x, y - 1, z);
            if (block.func_149688_o() == Material.field_151579_a && (!this.requiresSolidGround || blockBelow.func_149721_r())) {
                PBEffectGenerateByGenerator.setBlockSafe(world, x, y - 1, z, Blocks.field_150346_d);
                WorldGenerator generator = PBEffectGenerateByGenerator.getRandomGenerator(this.getGenerators(), this.generatorFlags, random);
                generator.func_76484_a(world, random, x, y, z);
            }
        }
    }

    public abstract WorldGenerator[] getGenerators();

    public static WorldGenerator getRandomGenerator(WorldGenerator[] generators, int flags, Random random) {
        int totalNumber = 0;
        for (int i = 0; i < generators.length; ++i) {
            int flag = 1 << i;
            if ((flags & flag) <= 0) continue;
            ++totalNumber;
        }
        int chosenGen = random.nextInt(totalNumber);
        for (int i = 0; i < generators.length; ++i) {
            int flag = 1 << i;
            if ((flags & flag) <= 0) continue;
            if (chosenGen == 0) {
                return generators[i];
            }
            --chosenGen;
        }
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74757_a("requiresSolidGround", this.requiresSolidGround);
        compound.func_74780_a("chancePerBlock", this.chancePerBlock);
        compound.func_74768_a("generatorFlags", this.generatorFlags);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.requiresSolidGround = compound.func_74767_n("requiresSolidGround");
        this.chancePerBlock = compound.func_74769_h("chancePerBlock");
        this.generatorFlags = compound.func_74762_e("generatorFlags");
    }
}

